/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.soap.api;

import de.ilias.services.filemanager.utils.FileManagerUtils;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class SoapClientFileLock {
    @XmlTransient
    protected static final Logger logger = Logger.getLogger(SoapClientFileLock.class.getName());
    @XmlAttribute(name="until")
    private String until = "";
    @XmlAttribute(name="user_id")
    private String user_id = "";
    @XmlAttribute(name="enable_download")
    private String enable_download = "";

    public String getUntil() {
        return this.until;
    }

    public long getRemainingSeconds() {
        long ut = FileManagerUtils.textToInt(this.until);
        if (ut <= 0L) {
            return 0L;
        }
        if ((ut -= System.currentTimeMillis() / 1000L) > 0L) {
            logger.info(String.valueOf(ut));
            return ut;
        }
        return 0L;
    }

    public String getUserId() {
        return this.user_id;
    }

    public boolean isDownloadEnabled() {
        return this.enable_download.equalsIgnoreCase("1");
    }

    public void enableDownload(boolean status) {
        this.enable_download = status ? "1" : "0";
    }

    public void setUntil(long until) {
        this.until = String.valueOf(until);
    }

    public void setUserId(int userId) {
        this.user_id = String.valueOf(userId);
    }
}

