/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.soap.api;

import de.ilias.services.filemanager.soap.api.SoapClientFileContent;
import de.ilias.services.filemanager.soap.api.SoapClientFileLock;
import de.ilias.services.filemanager.utils.Base64;
import de.ilias.services.filemanager.utils.FileManagerUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="File")
public class SoapClientFile {
    @XmlTransient
    private static final Logger logger = Logger.getLogger(SoapClientFile.class.getName());
    private String Filename;
    private String Title;
    private String Description;
    private SoapClientFileLock Lock;
    @XmlElement(name="Content")
    private SoapClientFileContent Content = new SoapClientFileContent();
    @XmlTransient
    private File tmp;

    public String getFilename() {
        return this.Filename;
    }

    public void setFilename(String name) {
        this.Filename = name;
    }

    public String getTitle() {
        return this.Title;
    }

    public void setTitle(String title) {
        this.Title = title;
    }

    public String getDescription() {
        return this.Description;
    }

    public File getFile() {
        return this.tmp;
    }

    public SoapClientFileLock getFileLock() {
        if (this.Lock == null) {
            this.Lock = new SoapClientFileLock();
            return this.Lock;
        }
        return this.Lock;
    }

    public void setFileLock(SoapClientFileLock lock) {
        this.Lock = lock;
    }

    public SoapClientFileContent getContent() {
        return this.Content;
    }

    public void setContent(SoapClientFileContent cont) {
        this.Content = cont;
    }

    public File writeToTempFile() throws IOException {
        File tmpDir = FileManagerUtils.createTempDirectory("ilfm_");
        tmpDir.deleteOnExit();
        File tmp = new File(tmpDir, this.getFilename());
        tmp.deleteOnExit();
        Base64.decodeFileToFile(this.getContent().getContentFile().getAbsolutePath(), tmp.getAbsolutePath());
        logger.info("Content written to: " + tmp.getAbsolutePath());
        return tmp;
    }

    public File writeToFile(File target) throws FileNotFoundException, IOException {
        logger.info(target.getAbsolutePath());
        Base64.decodeFileToFile(this.getContent().getContentFile().getAbsolutePath(), target.getAbsolutePath());
        return target;
    }
}

