/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.soap;

import de.ilias.services.filemanager.rest.RestClientConnector;
import de.ilias.services.filemanager.soap.SoapClientConnectorException;
import de.ilias.services.filemanager.soap.api.SoapClientAddFileRequest;
import de.ilias.services.filemanager.soap.api.SoapClientAddFileResponse;
import de.ilias.services.filemanager.soap.api.SoapClientAddObjectRequest;
import de.ilias.services.filemanager.soap.api.SoapClientAddObjectResponse;
import de.ilias.services.filemanager.soap.api.SoapClientDeleteObjectRequest;
import de.ilias.services.filemanager.soap.api.SoapClientDeleteObjectResponse;
import de.ilias.services.filemanager.soap.api.SoapClientFile;
import de.ilias.services.filemanager.soap.api.SoapClientGetFileXMLRequest;
import de.ilias.services.filemanager.soap.api.SoapClientGetFileXMLResponse;
import de.ilias.services.filemanager.soap.api.SoapClientGetObjectByReferenceRequest;
import de.ilias.services.filemanager.soap.api.SoapClientGetObjectByReferenceResponse;
import de.ilias.services.filemanager.soap.api.SoapClientGetTreeChildsRequest;
import de.ilias.services.filemanager.soap.api.SoapClientGetTreeChildsResponse;
import de.ilias.services.filemanager.soap.api.SoapClientGetUserIdFromSidRequest;
import de.ilias.services.filemanager.soap.api.SoapClientGetUserIdFromSidResponse;
import de.ilias.services.filemanager.soap.api.SoapClientGetUserXMLRequest;
import de.ilias.services.filemanager.soap.api.SoapClientGetUserXMLResponse;
import de.ilias.services.filemanager.soap.api.SoapClientLoginException;
import de.ilias.services.filemanager.soap.api.SoapClientLoginRequest;
import de.ilias.services.filemanager.soap.api.SoapClientLoginResponse;
import de.ilias.services.filemanager.soap.api.SoapClientObjects;
import de.ilias.services.filemanager.soap.api.SoapClientResponse;
import de.ilias.services.filemanager.soap.api.SoapClientSearchObjectsRequest;
import de.ilias.services.filemanager.soap.api.SoapClientSearchObjectsResponse;
import de.ilias.services.filemanager.soap.api.SoapClientUpdateFileRequest;
import de.ilias.services.filemanager.soap.api.SoapClientUpdateFileResponse;
import de.ilias.services.filemanager.soap.api.SoapClientUpdateObjectsRequest;
import de.ilias.services.filemanager.soap.api.SoapClientUpdateObjectsResponse;
import de.ilias.services.filemanager.soap.api.SoapClientUser;
import de.ilias.services.filemanager.user.RemoteAccount;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;

public class SoapClientConnector {
    protected static final Logger logger = Logger.getLogger(SoapClientConnector.class.getName());
    public static final int FRAME_RIGHT = 1;
    public static final int FRAME_LEFT = 2;
    protected static final String QNAME_SERVICE_URI = "urn:ilUserAdministration";
    protected static final String QNAME_SERVICE_LOCAL = "ILIASSoapWebservice";
    protected static final String QNAME_PORT_URI = "urn:ilUserAdministration";
    protected static final String QNAME_PORT_LOCAL = "ILIASSoapWebservicePort";
    private static HashMap<Integer, SoapClientConnector> instances = new HashMap();
    private String wsdl = "";
    private String client = "";
    private String user = "";
    private int userId = 0;
    private String pass = "";
    private String sid = "";
    private Service service;
    private Dispatch dispatch;

    private SoapClientConnector() {
    }

    public static SoapClientConnector getInstance() {
        return SoapClientConnector.getInstance(1);
    }

    public static SoapClientConnector getInstance(int frame) {
        if (instances.containsKey(frame)) {
            return instances.get(frame);
        }
        instances.put(frame, new SoapClientConnector());
        return instances.get(frame);
    }

    public void setWsdlUri(String uri) {
        this.wsdl = uri;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public void setUser(String soapUser) {
        this.user = soapUser;
    }

    public void setUserId(int id) {
        this.userId = id;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setPassword(String soapPass) {
        this.pass = soapPass;
    }

    public void setSessionId(String soapSid) {
        this.sid = soapSid;
    }

    public void init() {
        try {
            this.service = Service.create((URL)new URL(this.wsdl), (QName)new QName("urn:ilUserAdministration", QNAME_SERVICE_LOCAL));
            this.dispatch = this.service.createDispatch(new QName("urn:ilUserAdministration", QNAME_PORT_LOCAL), Source.class, Service.Mode.PAYLOAD);
        }
        catch (MalformedURLException ex) {
            logger.log(Level.SEVERE, "Cannot connect to ILIAS webservice " + this.wsdl + " " + ex.getMessage());
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
    }

    public void login() throws SoapClientConnectorException, SoapClientLoginException {
        SoapClientLoginRequest loginRequest = new SoapClientLoginRequest();
        loginRequest.setClient(this.client);
        loginRequest.setUsername(this.user);
        loginRequest.setPassword(this.pass);
        try {
            Source response = (Source)this.dispatch.invoke((Object)this.marshall(loginRequest));
            SoapClientLoginResponse loginResponse = (SoapClientLoginResponse)this.unmarshall(SoapClientLoginResponse.class, response);
            this.setSessionId(loginResponse.getSid());
        }
        catch (SOAPFaultException e) {
            logger.severe("Unable to login");
            throw new SoapClientLoginException(e.getMessage());
        }
        catch (Exception e) {
            logger.severe("Unable to login");
            throw new SoapClientConnectorException(e.getMessage());
        }
    }

    public void fetchUserId() throws SoapClientConnectorException {
        SoapClientGetUserIdFromSidResponse userResponse;
        try {
            SoapClientGetUserIdFromSidRequest request = new SoapClientGetUserIdFromSidRequest();
            logger.log(Level.INFO, "Current sesion id is {0}", this.sid);
            request.setSid(this.sid);
            Source response = (Source)this.dispatch.invoke((Object)this.marshall(request));
            userResponse = (SoapClientGetUserIdFromSidResponse)this.unmarshall(SoapClientGetUserIdFromSidResponse.class, response);
        }
        catch (Exception e) {
            logger.severe("Unable to fetch user id");
            throw new SoapClientConnectorException(e.getMessage());
        }
        logger.fine("Received user id " + userResponse.getUserId());
        this.setUserId(userResponse.getUserId());
    }

    public RemoteAccount initUser() throws SoapClientConnectorException {
        if (this.sid.isEmpty()) {
            try {
                this.login();
                this.fetchUserId();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SoapClientConnectorException(e.getMessage());
            }
        }
        SoapClientGetUserXMLRequest request = new SoapClientGetUserXMLRequest();
        request.setSid(this.sid);
        request.setUserIds(new int[]{this.getUserId()});
        request.setAttachRoles(false);
        Source response = (Source)this.dispatch.invoke((Object)this.marshall(request));
        logger.info("Trying to unmarshall soap request...");
        SoapClientGetUserXMLResponse responseXml = (SoapClientGetUserXMLResponse)this.unmarshall(SoapClientGetUserXMLResponse.class, response);
        try {
            logger.info("Trying to unmarshall soap response xml...");
            responseXml.unmarshall();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            logger.info(ex.getMessage());
            throw new SoapClientConnectorException(ex.getMessage());
        }
        if (responseXml.getUsers() == null) {
            throw new SoapClientConnectorException("Did not receive valid xml from soap service");
        }
        if (responseXml.getUsers().getUsers() == null) {
            throw new SoapClientConnectorException("Did not receive user account information.");
        }
        logger.log(Level.FINEST, "Reading remote user.");
        Iterator<SoapClientUser> ite = responseXml.getUsers().getUsers().iterator();
        while (ite.hasNext()) {
            RemoteAccount.newInstance(ite.next());
            logger.info("Received user account data from " + RemoteAccount.getInstance().getUser().getLogin());
        }
        return RemoteAccount.getInstance();
    }

    public SoapClientObjects getObjectByReference(int refId) throws SoapClientConnectorException {
        SoapClientGetObjectByReferenceRequest request = new SoapClientGetObjectByReferenceRequest();
        request.setSid(this.sid);
        request.setRefId(refId);
        request.setUserId(this.getUserId());
        logger.info("Session id is" + this.sid);
        Source response = (Source)this.dispatch.invoke((Object)this.marshall(request));
        SoapClientGetObjectByReferenceResponse responseXml = (SoapClientGetObjectByReferenceResponse)this.unmarshall(SoapClientGetObjectByReferenceResponse.class, response);
        try {
            logger.fine("Trying to unmarshall soap response xml...");
            responseXml.unmarshall();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            throw new SoapClientConnectorException(ex.getMessage());
        }
        if (responseXml.getObjects() == null) {
            throw new SoapClientConnectorException("Did not receive valid xml from soap service");
        }
        if (responseXml.getObjects().getObjects() == null) {
            throw new SoapClientConnectorException("Did not receive user account information.");
        }
        return responseXml.getObjects();
    }

    public boolean updateObjects(SoapClientObjects objects) {
        SoapClientUpdateObjectsRequest request = new SoapClientUpdateObjectsRequest();
        request.setSid(this.sid);
        request.setObjects(objects);
        Source response = (Source)this.dispatch.invoke((Object)this.marshall(request));
        SoapClientUpdateObjectsResponse responseXml = (SoapClientUpdateObjectsResponse)this.unmarshall(SoapClientUpdateObjectsResponse.class, response);
        return responseXml.getSuccess();
    }

    public int addObject(SoapClientObjects objects, int targetId) {
        SoapClientAddObjectRequest request = new SoapClientAddObjectRequest();
        request.setSid(this.sid);
        request.setTargetId(targetId);
        request.setObjects(objects);
        Source response = (Source)this.dispatch.invoke((Object)this.marshall(request));
        SoapClientAddObjectResponse responseXml = (SoapClientAddObjectResponse)this.unmarshall(SoapClientAddObjectResponse.class, response);
        return responseXml.getRefId();
    }

    public boolean deleteObject(int refId) {
        SoapClientDeleteObjectRequest request = new SoapClientDeleteObjectRequest();
        request.setSid(this.sid);
        request.setReferenceId(refId);
        Source response = (Source)this.dispatch.invoke((Object)this.marshall(request));
        SoapClientDeleteObjectResponse responseXml = (SoapClientDeleteObjectResponse)this.unmarshall(SoapClientDeleteObjectResponse.class, response);
        return responseXml.getSuccess();
    }

    public int addFile(SoapClientFile file, int targetId) {
        file = RestClientConnector.getInstance().addFile(file);
        SoapClientAddFileRequest request = new SoapClientAddFileRequest();
        request.setSid(this.sid);
        request.setTargetId(targetId);
        request.setFile(file);
        Source response = (Source)this.dispatch.invoke((Object)this.marshall(request));
        SoapClientAddFileResponse responseXml = (SoapClientAddFileResponse)this.unmarshall(SoapClientAddFileResponse.class, response);
        logger.info(String.valueOf(responseXml.getRefId()));
        return responseXml.getRefId();
    }

    public boolean updateFile(SoapClientFile file, int refId) {
        file = RestClientConnector.getInstance().addFile(file);
        SoapClientUpdateFileRequest request = new SoapClientUpdateFileRequest();
        request.setSid(this.sid);
        request.setTargetId(refId);
        request.setFile(file);
        Source response = (Source)this.dispatch.invoke((Object)this.marshall(request));
        SoapClientUpdateFileResponse responseXml = (SoapClientUpdateFileResponse)this.unmarshall(SoapClientUpdateFileResponse.class, response);
        return responseXml.getSuccess();
    }

    public boolean updateFileMD(SoapClientFile file, int refId) {
        file.setContent(null);
        SoapClientUpdateFileRequest request = new SoapClientUpdateFileRequest();
        request.setSid(this.sid);
        request.setTargetId(refId);
        request.setFile(file);
        Source response = (Source)this.dispatch.invoke((Object)this.marshall(request));
        SoapClientUpdateFileResponse responseXml = (SoapClientUpdateFileResponse)this.unmarshall(SoapClientUpdateFileResponse.class, response);
        return responseXml.getSuccess();
    }

    public SoapClientObjects getTreeChilds(int refId) throws SoapClientConnectorException {
        SoapClientGetTreeChildsRequest request = new SoapClientGetTreeChildsRequest();
        request.setSid(this.sid);
        request.setRefId(refId);
        request.setUserId(this.getUserId());
        Source response = (Source)this.dispatch.invoke((Object)this.marshall(request));
        SoapClientGetTreeChildsResponse responseXml = (SoapClientGetTreeChildsResponse)this.unmarshall(SoapClientGetTreeChildsResponse.class, response);
        try {
            logger.fine("Trying to unmarshall soap response xml...");
            responseXml.unmarshall();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            throw new SoapClientConnectorException(ex.getMessage());
        }
        if (responseXml.getObjects() == null) {
            throw new SoapClientConnectorException("Did not receive valid xml from soap service");
        }
        if (responseXml.getObjects().getObjects() == null) {
            throw new SoapClientConnectorException("Did not receive user account information.");
        }
        return responseXml.getObjects();
    }

    public SoapClientObjects search(String query) throws SoapClientConnectorException {
        SoapClientSearchObjectsRequest request = new SoapClientSearchObjectsRequest();
        request.setSid(this.sid);
        request.setQuery(query);
        request.setCombination("and");
        request.setUserId(this.getUserId());
        Source response = (Source)this.dispatch.invoke((Object)this.marshall(request));
        SoapClientSearchObjectsResponse responseXml = (SoapClientSearchObjectsResponse)this.unmarshall(SoapClientSearchObjectsResponse.class, response);
        try {
            responseXml.unmarshall();
        }
        catch (JAXBException e) {
            logger.warning(e.getMessage());
            return new SoapClientObjects();
        }
        if (responseXml.getObjects() == null) {
            throw new SoapClientConnectorException("Did not receive valid xml from soap service");
        }
        if (responseXml.getObjects().getObjects() == null) {
            throw new SoapClientConnectorException("Did not receive user account information.");
        }
        return responseXml.getObjects();
    }

    public SoapClientFile getFileXML(int refId) throws SoapClientConnectorException {
        SoapClientFile file;
        SoapClientGetFileXMLRequest request = new SoapClientGetFileXMLRequest();
        request.setSid(this.sid);
        request.setRefId(refId);
        Source response = (Source)this.dispatch.invoke((Object)this.marshall(request));
        SoapClientGetFileXMLResponse responseXml = (SoapClientGetFileXMLResponse)this.unmarshall(SoapClientGetFileXMLResponse.class, response);
        try {
            logger.fine("Trying to unmarshall soap response xml...");
            responseXml.unmarshall();
            logger.info(responseXml.getFile().getContent().getValue());
            file = RestClientConnector.getInstance().getFile(responseXml.getFile());
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            throw new SoapClientConnectorException(ex.getMessage());
        }
        return file;
    }

    private StreamSource marshall(Object loginRequest) {
        StringWriter writer = new StringWriter();
        StreamSource streamSource = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{loginRequest.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal(loginRequest, (Writer)writer);
            return new StreamSource(new ByteArrayInputStream(writer.toString().getBytes("UTF-8")));
        }
        catch (Exception ex) {
            logger.warning("Unable to marshall request...");
            ex.printStackTrace();
            logger.severe(ex.getMessage());
            return streamSource;
        }
    }

    private SoapClientResponse unmarshall(Class responseHandler, Source response) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{responseHandler});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (SoapClientResponse)unmarshaller.unmarshal(response);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage());
            return null;
        }
    }
}

