/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import de.ilias.services.filemanager.rest.api.RestGetFileResponse;
import de.ilias.services.filemanager.rest.api.RestPostFileRequest;
import de.ilias.services.filemanager.soap.api.SoapClientFile;
import de.ilias.services.filemanager.utils.Base64;
import de.ilias.services.filemanager.utils.FileManagerUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Logger;

public class RestClientConnector {
    protected static final Logger logger = Logger.getLogger(RestClientConnector.class.getName());
    public static final int FRAME_RIGHT = 1;
    public static final int FRAME_LEFT = 2;
    protected static final String FILE_STORAGE = "fileStorage";
    private String server = "";
    private Client client = null;
    private static HashMap<Integer, RestClientConnector> instances = new HashMap();

    private RestClientConnector() {
    }

    public static RestClientConnector getInstance() {
        return RestClientConnector.getInstance(1);
    }

    public static RestClientConnector getInstance(int frame) {
        if (instances.containsKey(frame)) {
            return instances.get(frame);
        }
        instances.put(frame, new RestClientConnector());
        return instances.get(frame);
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public Client getClient() {
        return this.client;
    }

    public SoapClientFile getFile(SoapClientFile file) {
        this.init("get");
        WebResource wr = this.client.resource(this.getServer() + "/" + FILE_STORAGE + "/" + file.getContent().getValue());
        InputStream responseStream = (InputStream)wr.accept(new String[]{"application/json"}).get(InputStream.class);
        try {
            File tmp = this.createTempFileFromStream(responseStream);
            file.getContent().setContentFile(tmp);
        }
        catch (IOException ex) {
            logger.severe(ex.getMessage());
        }
        return file;
    }

    public SoapClientFile addFile(SoapClientFile file) {
        try {
            this.init("post");
            File tmp = FileManagerUtils.createTempFile();
            Base64.encodeFileToFile(file.getContent().getContentFile().getAbsolutePath(), tmp.getAbsolutePath());
            WebResource wr = this.client.resource(this.getServer() + "/" + FILE_STORAGE);
            MultivaluedMapImpl mvm = new MultivaluedMapImpl();
            mvm.add("content", FileManagerUtils.fileToString(tmp));
            String response = (String)wr.accept(new String[]{"application/json"}).post(String.class, (Object)mvm);
            logger.info("Response add rest file: " + response);
            file.getContent().setValue(response);
        }
        catch (IOException ex) {
            logger.severe(ex.getMessage());
        }
        return file;
    }

    public void init(String type) {
        DefaultClientConfig config = new DefaultClientConfig();
        if (type.equals("get")) {
            config.getClasses().add(RestGetFileResponse.class);
        } else if (type.equals("post")) {
            config.getClasses().add(RestPostFileRequest.class);
        }
        this.client = Client.create((ClientConfig)config);
    }

    public File createTempFileFromStream(InputStream is) throws IOException {
        int len;
        File temp = FileManagerUtils.createTempFile();
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(temp);
        }
        catch (FileNotFoundException ex) {
            logger.severe(ex.getMessage());
        }
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) > 0) {
            ((OutputStream)os).write(buffer, 0, len);
        }
        ((OutputStream)os).close();
        is.close();
        return temp;
    }

    public File decodeFile(File decoded) throws IOException {
        File temp = FileManagerUtils.createTempFile();
        Base64.decodeFileToFile(decoded.getAbsolutePath(), temp.getAbsolutePath());
        return temp;
    }
}

