/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.layout;

import de.ilias.services.filemanager.FileManager;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.geometry.Rectangle2D;
import javafx.scene.input.MouseEvent;
import javafx.stage.Screen;

public class WindowManager {
    private static final Logger logger = Logger.getLogger(WindowManager.class.getName());
    private static WindowManager instance = null;
    private boolean maximized = false;
    private Rectangle2D memSize = null;
    private double offsetX = 0.0;
    private double offsetY = 0.0;

    private WindowManager() {
    }

    public static WindowManager getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new WindowManager();
        return instance;
    }

    public void storePosition(MouseEvent event) {
        this.offsetX = event.getSceneX();
        this.offsetY = event.getSceneY();
    }

    public void move(MouseEvent event) {
        if (!this.isMaximized()) {
            FileManager.getInstance().getStage().setX(event.getScreenX() - this.offsetX);
            FileManager.getInstance().getStage().setY(event.getScreenY() - this.offsetY);
        }
    }

    public void close() {
        Platform.exit();
    }

    public void inconify() {
        FileManager.getInstance().getStage().setIconified(true);
    }

    public void toggle() {
        if (FileManager.getInstance().isApplet()) {
            return;
        }
        Screen screen = (Screen)Screen.getScreensForRectangle((double)FileManager.getInstance().getStage().getX(), (double)FileManager.getInstance().getStage().getY(), (double)1.0, (double)1.0).get(0);
        if (this.isMaximized()) {
            this.maximized = false;
            if (this.memSize != null) {
                FileManager.getInstance().getStage().setX(this.memSize.getMinX());
                FileManager.getInstance().getStage().setY(this.memSize.getMinY());
                FileManager.getInstance().getStage().setWidth(this.memSize.getWidth());
                FileManager.getInstance().getStage().setHeight(this.memSize.getHeight());
            }
        } else {
            this.maximized = true;
            this.memSize = new Rectangle2D(FileManager.getInstance().getStage().getX(), FileManager.getInstance().getStage().getY(), FileManager.getInstance().getStage().getWidth(), FileManager.getInstance().getStage().getHeight());
            logger.finer("Width: " + this.memSize.getWidth());
            logger.finer("Height: " + this.memSize.getHeight());
            FileManager.getInstance().getStage().setX(screen.getVisualBounds().getMinX());
            FileManager.getInstance().getStage().setY(screen.getVisualBounds().getMinY());
            FileManager.getInstance().getStage().setWidth(screen.getVisualBounds().getWidth());
            FileManager.getInstance().getStage().setHeight(screen.getVisualBounds().getHeight());
        }
    }

    public boolean isMaximized() {
        return this.maximized;
    }
}

