/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.layout;

import de.ilias.services.filemanager.FileManager;
import de.ilias.services.filemanager.content.ContentFrameDirectoryStack;
import de.ilias.services.filemanager.content.DirectoryStackItem;
import de.ilias.services.filemanager.content.ListItemReader;
import de.ilias.services.filemanager.content.ListViewItemParser;
import de.ilias.services.filemanager.controller.MainController;
import de.ilias.services.filemanager.skin.SkinFactory;
import de.ilias.services.filemanager.soap.SoapClientConnectorException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class LayoutMaster {
    private static final Logger logger = Logger.getLogger(LayoutMaster.class.getName());
    private Stage stage = null;
    private boolean localFrameEnabled = false;

    LayoutMaster(Stage stage) {
        this.stage = stage;
    }

    public boolean isLocalFrameEnabled() {
        return this.localFrameEnabled;
    }

    public void enableLocalFrame(boolean en) {
        this.localFrameEnabled = en;
    }

    public void init() throws IOException {
        ListViewItemParser parser;
        ListItemReader reader;
        Parent root = (Parent)FXMLLoader.load((URL)this.getClass().getResource("MainLayout.fxml"));
        root.setId("rootStack");
        this.stage.setScene(new Scene(root));
        this.stage.initStyle(StageStyle.DECORATED);
        SkinFactory.loadSkin(this.stage);
        ContentFrameDirectoryStack dirStack = ContentFrameDirectoryStack.getInstance();
        if (this.isLocalFrameEnabled()) {
            DirectoryStackItem home = new DirectoryStackItem();
            home.setType(1);
            home.setFile(new File(System.getProperty("user.home")));
            logger.info("Starting with local directory: " + home.getFile().getAbsolutePath());
            dirStack.getLocalStack().add(home);
            reader = new ListItemReader();
            try {
                reader.read(1);
            }
            catch (SoapClientConnectorException ex) {
                logger.severe("Cannot read local content");
            }
            parser = new ListViewItemParser(1);
            parser.setListItems(reader.getListItems());
            parser.sort();
            MainController.getInstance().populateLocalList(parser.parse());
        } else {
            MainController.getInstance().switchOneFrame();
        }
        DirectoryStackItem repo = new DirectoryStackItem();
        repo.setType(2);
        repo.setId(FileManager.getInstance().getInitialRepositoryContainerId());
        logger.info("Starting with remote container: " + repo.getId());
        dirStack.getRemoteStack().add(repo);
        reader = new ListItemReader();
        try {
            reader.read(2);
        }
        catch (SoapClientConnectorException ex) {
            logger.severe("Cannot read remote content");
        }
        parser = new ListViewItemParser(2);
        parser.setListItems(reader.getListItems());
        parser.sort();
        MainController.getInstance().populateRemoteList(parser.parse());
        MainController.getInstance().fillBreadcrumb(reader);
        MainController.getInstance().initModalDialog();
    }

    public void show() {
        this.stage.show();
    }
}

