/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.events;

import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.content.ListItemActionContextMenu;
import de.ilias.services.filemanager.content.LocalListItem;
import de.ilias.services.filemanager.content.RemoteListItem;
import de.ilias.services.filemanager.controller.MainController;
import de.ilias.services.filemanager.events.ListItemEventHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;

public class ListItemMouseEventHandler
extends ListItemEventHandler
implements EventHandler<MouseEvent> {
    private Node source;
    private static ListItemActionContextMenu CURRENT_MENU;

    public ListItemMouseEventHandler(ListItem item, Node source) {
        super(item);
        this.source = source;
    }

    public Node getNode() {
        return this.source;
    }

    public void handle(MouseEvent me) {
        logger.finer("New mouse event " + me.getEventType().getName());
        if (me.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.handleSelectionModel(me);
            if (CURRENT_MENU != null) {
                CURRENT_MENU.hide();
            }
            if (me.isSecondaryButtonDown()) {
                if (me.getSource() instanceof ListView) {
                    ListItem currentItem = (ListItem)((Node)me.getSource()).getUserData();
                    MainController.getInstance().getList(this.getListItem()).getSelectionModel().clearSelection();
                }
                ListItemActionContextMenu cm = new ListItemActionContextMenu(this.getSelectedNodes(), (Node)me.getSource());
                cm.show((Node)me.getSource(), me.getScreenX(), me.getScreenY());
                CURRENT_MENU = cm;
            }
            me.consume();
            return;
        }
        if (me.getEventType() == MouseEvent.MOUSE_RELEASED) {
            this.handleSelectionModel(me);
            me.consume();
            return;
        }
        if (me.getEventType() == MouseEvent.MOUSE_CLICKED) {
            logger.fine("New click event for " + this.getListItem().getTitle());
            if (me.getClickCount() == 2) {
                this.handleOpenAction(false);
                me.consume();
            }
        }
        if (me.getEventType() == MouseEvent.DRAG_DETECTED) {
            ListItem item;
            ListView list;
            logger.finer("Start drag detected");
            if (!this.getListItem().isReadable()) {
                logger.info("Source is not readable!");
                me.consume();
                return;
            }
            Dragboard db = this.getNode().startDragAndDrop(new TransferMode[]{TransferMode.COPY});
            ClipboardContent content = new ClipboardContent();
            if (this.getListItem() instanceof LocalListItem) {
                ArrayList<File> files = new ArrayList<File>();
                list = MainController.getInstance().getLocalList();
                list.getSelectionModel().getSelectedItems();
                for (Node node : list.getSelectionModel().getSelectedItems()) {
                    item = (ListItem)node.getUserData();
                    files.add(new File(item.getAbsolutePath()));
                    logger.info("Adding " + item.getAbsolutePath() + " to clipboard");
                }
                content.putFiles(files);
                db.setContent((Map)content);
            }
            if (this.getListItem() instanceof RemoteListItem) {
                StringBuilder refs = new StringBuilder();
                list = MainController.getInstance().getRemoteList();
                for (Node node : list.getSelectionModel().getSelectedItems()) {
                    item = (ListItem)node.getUserData();
                    refs.append(" " + item.getRefId());
                }
                logger.info("Adding " + refs.toString() + " to clipboard");
                content.putString(refs.toString());
                db.setContent((Map)content);
            }
            me.consume();
        }
    }

    protected void handleSelectionModel(MouseEvent me) {
        ((Node)me.getSource()).setFocusTraversable(true);
        logger.finer("Node is not focused");
        if (me.getEventType() == MouseEvent.MOUSE_RELEASED) {
            if (this.isSourceSelected(me)) {
                // empty if block
            }
            me.consume();
            return;
        }
        if (me.isControlDown() && me.isPrimaryButtonDown() && this.isSourceSelected(me)) {
            int currentIndex = MainController.getInstance().getList(this.getListItem()).getItems().indexOf(me.getSource());
            MainController.getInstance().getList(this.getListItem()).getSelectionModel().clearSelection(currentIndex);
            me.consume();
            return;
        }
        if (me.isShiftDown()) {
            int SelIndex = MainController.getInstance().getList(this.getListItem()).getSelectionModel().getSelectedIndex();
            int currentIndex = MainController.getInstance().getList(this.getListItem()).getItems().indexOf(me.getSource());
            logger.finer("Current index is: " + currentIndex);
            MainController.getInstance().getList(this.getListItem()).getSelectionModel().selectRange(SelIndex, currentIndex);
            MainController.getInstance().getList(this.getListItem()).getSelectionModel().select(currentIndex);
            me.consume();
            return;
        }
        if (me.isPrimaryButtonDown()) {
            if (this.isSourceSelected(me)) {
                return;
            }
            if (!me.isControlDown()) {
                MainController.getInstance().getList(this.getListItem()).getSelectionModel().clearSelection();
            }
            MainController.getInstance().getList(this.getListItem()).getSelectionModel().select(me.getSource());
            return;
        }
        if (me.isSecondaryButtonDown()) {
            if (me.isControlDown()) {
                MainController.getInstance().getList(this.getListItem()).getSelectionModel().select(me.getSource());
                return;
            }
            if (!this.isSourceSelected(me)) {
                MainController.getInstance().getList(this.getListItem()).getSelectionModel().clearSelection();
            }
            MainController.getInstance().getList(this.getListItem()).getSelectionModel().select(me.getSource());
        }
    }

    protected boolean isSourceSelected(MouseEvent me) {
        for (Node selectedNode : MainController.getInstance().getList(this.getListItem()).getSelectionModel().getSelectedItems()) {
            if (selectedNode != me.getSource()) continue;
            return true;
        }
        return false;
    }

    protected ObservableList<Node> getSelectedNodes() {
        return MainController.getInstance().getList(this.getListItem()).getSelectionModel().getSelectedItems();
    }
}

