/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.events;

import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.events.ListItemEventHandler;
import java.util.Iterator;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class ListItemKeyEventHandler
extends ListItemEventHandler
implements EventHandler<KeyEvent> {
    protected static final Logger logger = Logger.getLogger(ListItemKeyEventHandler.class.getName());
    private boolean multipleSelected = false;

    public ListItemKeyEventHandler(ListItem item) {
        super(item);
    }

    public boolean areMultipleSelected() {
        return this.multipleSelected;
    }

    public void handle(KeyEvent ke) {
        if (ke.getEventType() == KeyEvent.KEY_RELEASED) {
            if (ke.isControlDown() && ke.getCode() == KeyCode.O || ke.getCode() == KeyCode.ENTER) {
                logger.info("Handling open action");
                this.initListItem(ke);
                if (!this.areMultipleSelected()) {
                    this.handleOpenAction(true);
                }
                ke.consume();
                return;
            }
            if (ke.isControlDown() && ke.getCode() == KeyCode.R) {
                logger.info("Handling rename");
                this.initListItem(ke);
                if (!this.areMultipleSelected()) {
                    this.handleRenameAction();
                }
                ke.consume();
                return;
            }
            if (ke.isControlDown() && ke.getCode() == KeyCode.L) {
                logger.info("Handling revision state editing");
                this.initListItem(ke);
                if (!this.areMultipleSelected()) {
                    this.handleRevisionStateEditingAction();
                }
                ke.consume();
                return;
            }
            if (ke.isControlDown() && ke.getCode() == KeyCode.C) {
                logger.info("Handling copy to clipboard action");
                this.initListItem(ke);
                this.handleCopyToClipboard();
                ke.consume();
                return;
            }
            if (ke.isControlDown() && ke.getCode() == KeyCode.A) {
                logger.info("Select all");
                this.selectAllItems((ListView)ke.getSource());
                ke.consume();
                return;
            }
            if (ke.isShiftDown() && ke.isControlDown() && ke.getCode() == KeyCode.I) {
                logger.info("Invert selection");
                this.invertSelection((ListView)ke.getSource());
                ke.consume();
                return;
            }
            if (ke.isControlDown() && ke.getCode() == KeyCode.V) {
                logger.info("Handling paste");
                this.initListItem(ke);
                this.handlePasteAction();
                ke.consume();
                return;
            }
            if (ke.getCode() == KeyCode.DELETE) {
                logger.info("Handling delete");
                this.initListItem(ke);
                this.handleDeleteAction();
                ke.consume();
                return;
            }
        }
        ke.consume();
    }

    protected void initListItem(KeyEvent ke) {
        this.setListItem((ListItem)((Node)ke.getSource()).getUserData());
        Iterator itemIte = ((ListView)ke.getSource()).getSelectionModel().getSelectedItems().iterator();
        int counter = 0;
        while (itemIte.hasNext()) {
            this.setListItem((ListItem)((Node)itemIte.next()).getUserData());
            ++counter;
        }
        if (counter > 1) {
            this.multipleSelected = true;
        }
    }
}

