/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.events;

import de.ilias.services.filemanager.action.ActionHandler;
import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.content.LocalListItem;
import de.ilias.services.filemanager.content.RemoteListItem;
import de.ilias.services.filemanager.controller.MainController;
import de.ilias.services.filemanager.dialog.DeleteDialog;
import de.ilias.services.filemanager.dialog.RenameDialog;
import de.ilias.services.filemanager.dialog.RevisionStateDialog;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.input.Clipboard;

public class ListItemEventHandler {
    protected static final Logger logger = Logger.getLogger(ListItemEventHandler.class.getName());
    private ListItem item = null;

    public ListItemEventHandler(ListItem item) {
        this.item = item;
    }

    public void setListItem(ListItem li) {
        this.item = li;
    }

    public ListItem getListItem() {
        return this.item;
    }

    protected void handleOpenAction(boolean openContainer) {
        if (!this.getListItem().isReadable()) {
            return;
        }
        if (this.getListItem().isContainer()) {
            if (openContainer && !(this.getListItem() instanceof RemoteListItem)) {
                try {
                    Desktop desktop = Desktop.getDesktop();
                    desktop.open(new File(this.getListItem().getAbsolutePath()));
                }
                catch (IOException ex) {
                    logger.warning("Cannot open file " + this.getListItem().getTitle());
                }
            } else {
                MainController.getInstance().getRoot().setCursor(Cursor.WAIT);
                if (this.getListItem().isUpperLink()) {
                    MainController.getInstance().switchDirectory(this.getListItem().getParent());
                } else {
                    MainController.getInstance().switchDirectory(this.getListItem());
                }
                MainController.getInstance().getRoot().setCursor(Cursor.DEFAULT);
            }
            return;
        }
        if (this.getListItem().isReadable() && !this.getListItem().getFileType().isEmpty()) {
            MainController.getInstance().getRoot().setCursor(Cursor.WAIT);
            if (this.getListItem() instanceof RemoteListItem) {
                MainController.getInstance().deliverRemoteItem(this.getListItem());
            }
            if (this.getListItem() instanceof LocalListItem) {
                try {
                    Desktop desktop = Desktop.getDesktop();
                    desktop.open(new File(this.getListItem().getAbsolutePath()));
                }
                catch (IOException ex) {
                    logger.warning("Cannot open file " + this.getListItem().getTitle());
                }
            }
            MainController.getInstance().getRoot().setCursor(Cursor.DEFAULT);
        }
    }

    protected void handleCopyToClipboard() {
        if (this.getListItem() instanceof RemoteListItem) {
            logger.info("Copy remote list item to clipboard");
            Clipboard clip = Clipboard.getSystemClipboard();
            clip.clear();
            Iterator selected = MainController.getInstance().getList(this.getListItem()).getSelectionModel().getSelectedItems().iterator();
            ArrayList<ListItem> items = new ArrayList<ListItem>();
            while (selected.hasNext()) {
                Node node = (Node)selected.next();
                ListItem selectedNode = (ListItem)node.getUserData();
                items.add(selectedNode);
            }
            ActionHandler.copyRemoteToClipboard(this.getListItem(), items);
        }
    }

    protected void selectAllItems(ListView view) {
        Iterator ite = view.getItems().iterator();
        int index = 0;
        while (ite.hasNext()) {
            ite.next();
            if (index > 0) {
                view.getSelectionModel().select(index);
            } else {
                view.getSelectionModel().clearSelection(index);
            }
            ++index;
        }
    }

    protected void invertSelection(ListView view) {
        Iterator ite = view.getItems().iterator();
        int index = 0;
        while (ite.hasNext()) {
            ite.next();
            if (view.getSelectionModel().isSelected(index)) {
                view.getSelectionModel().clearSelection(index);
            } else {
                view.getSelectionModel().select(index);
            }
            ++index;
        }
    }

    protected void handlePasteAction() {
        ActionHandler.pasteFromClipboard(this.getListItem(), Clipboard.getSystemClipboard().getFiles());
        Clipboard.getSystemClipboard().clear();
    }

    protected void handleRenameAction() {
        RenameDialog rename = new RenameDialog(this.getListItem());
        rename.parse();
        MainController.getInstance().showModalDialog((Node)rename);
    }

    protected void handleDeleteAction() {
        if (!this.getListItem().isDeletable()) {
            return;
        }
        DeleteDialog delete = new DeleteDialog(this.getListItem());
        delete.parse();
        MainController.getInstance().showModalDialog((Node)delete);
    }

    protected void handleRevisionStateEditingAction() {
        if (!this.getListItem().isWritable()) {
            return;
        }
        if (!this.getListItem().getType().equals("file")) {
            return;
        }
        RevisionStateDialog rs = new RevisionStateDialog(this.getListItem());
        rs.parse();
        MainController.getInstance().showModalDialog((Node)rs);
    }
}

