/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.events;

import de.ilias.services.filemanager.FileManager;
import de.ilias.services.filemanager.action.ActionHandler;
import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.events.ListItemEventHandler;
import java.io.File;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;

public class ListItemDragEventHandler
extends ListItemEventHandler
implements EventHandler<DragEvent> {
    public ListItemDragEventHandler(ListItem item) {
        super(item);
    }

    public void handle(DragEvent de) {
        if (de.getEventType() == DragEvent.DRAG_OVER) {
            this.handleDragOver(de);
        }
        if (de.getEventType() == DragEvent.DRAG_DROPPED) {
            this.handleDropped(de);
        }
        de.consume();
    }

    protected void handleDragOver(DragEvent de) {
        Node pane = (Node)de.getGestureSource();
        if (!this.getListItem().isWritable()) {
            logger.info("Drag target is not writable");
            return;
        }
        if (!this.getListItem().isContainer() && FileManager.getInstance().getFmMode() == 0) {
            if (this.getListItem().getType().equalsIgnoreCase("file") && de.getDragboard().getFiles().size() != 1) {
                logger.info("Drag only one file in file object");
                return;
            }
            for (File file : de.getDragboard().getFiles()) {
                if (!file.isDirectory()) continue;
                logger.info("Cannot replace file version with directory");
                return;
            }
        }
        if (!de.getDragboard().hasFiles()) {
            logger.info("Dragboard does not contain files");
            return;
        }
        de.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
    }

    protected void handleDropped(DragEvent de) {
        logger.info("New drop event");
        ActionHandler.pasteFromClipboard(this.getListItem(), de.getDragboard().getFiles());
        de.getDragboard().clear();
        de.setDropCompleted(true);
    }
}

