/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.events;

import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.content.LocalListItem;
import de.ilias.services.filemanager.content.RemoteListItem;
import de.ilias.services.filemanager.controller.MainController;
import de.ilias.services.filemanager.dialog.CreateDialog;
import de.ilias.services.filemanager.events.ListItemEventHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;

public class ListItemContextMenuEventHandler
extends ListItemEventHandler
implements EventHandler<ActionEvent> {
    private static final Logger logger = Logger.getLogger(ListItemContextMenuEventHandler.class.getName());
    public static final int ACTION_OPEN = 1;
    public static final int ACTION_COPY = 2;
    public static final int ACTION_PASTE = 3;
    public static final int ACTION_DELETE = 4;
    public static final int ACTION_RENAME = 5;
    public static final int ACTION_COPY_TO_CLIPBOARD = 6;
    public static final int ACTION_CREATE_CAT = 7;
    public static final int ACTION_CREATE_CRS = 8;
    public static final int ACTION_CREATE_FOLD = 9;
    public static final int ACTION_CREATE_GRP = 10;
    public static final int ACTION_EDIT_REVISION_STATE = 20;
    private int actionType = 0;

    public ListItemContextMenuEventHandler(ListItem item, int actionType) {
        super(item);
        this.actionType = actionType;
    }

    public void handle(ActionEvent ae) {
        switch (this.actionType) {
            case 1: {
                logger.info("Handling action 'open'");
                this.handleOpenAction(true);
                break;
            }
            case 2: {
                logger.info("Handling action 'COPY'");
                this.handleCopyAction();
                break;
            }
            case 6: {
                logger.info("Handling action 'COPY to CLIPBOARD'");
                this.handleCopyToClipboard();
                break;
            }
            case 3: {
                logger.info("Handling action 'PASTE'");
                this.handlePasteAction();
                break;
            }
            case 4: {
                logger.info("Handling action 'DELETE'");
                this.handleDeleteAction();
                break;
            }
            case 5: {
                logger.info("Handling action 'RENAME'");
                this.handleRenameAction();
                break;
            }
            case 7: {
                logger.info("Handling action 'CREATE CAT'");
                this.handleCreateAction(this.actionType);
                break;
            }
            case 8: {
                logger.info("Handling action 'CREATE CRS'");
                this.handleCreateAction(this.actionType);
                break;
            }
            case 10: {
                logger.info("Handling action 'CREATE GRP'");
                this.handleCreateAction(this.actionType);
                break;
            }
            case 9: {
                logger.info("Handling action 'CREATE FOLD'");
                this.handleCreateAction(this.actionType);
                break;
            }
            case 20: {
                logger.info("Handling action 'EDIT REVISION STATE'");
                this.handleRevisionStateEditingAction();
            }
        }
    }

    protected void handleCreateAction(int type) {
        CreateDialog create = new CreateDialog(this.getListItem(), type);
        create.parse();
        MainController.getInstance().showModalDialog((Node)create);
    }

    protected void handleCopyAction() {
        if (this.getListItem() instanceof LocalListItem) {
            Clipboard clip = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            ArrayList<File> files = new ArrayList<File>();
            clip.clear();
            for (Node node : MainController.getInstance().getList(this.getListItem()).getSelectionModel().getSelectedItems()) {
                ListItem selectedNode = (ListItem)node.getUserData();
                files.add(new File(selectedNode.getAbsolutePath()));
            }
            content.putFiles(files);
            clip.setContent((Map)content);
        }
        if (this.getListItem() instanceof RemoteListItem) {
            // empty if block
        }
    }
}

