/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.dialog;

import de.ilias.services.filemanager.FileManager;
import de.ilias.services.filemanager.utils.FileManagerUtils;
import java.io.File;
import java.util.ArrayList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;

public class UploadLimitConflictDialog
extends VBox {
    private ArrayList<File> errorFiles = new ArrayList();

    public UploadLimitConflictDialog(ArrayList<File> files) {
        this.errorFiles = files;
        this.init();
    }

    public void parse() {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(12.0);
        Label warningLabel = new Label();
        warningLabel.setId("warning");
        warningLabel.setAlignment(Pos.CENTER);
        warningLabel.setVisible(true);
        warningLabel.setText("Could not copy the following files, since the upload limit of " + String.valueOf(FileManager.getInstance().getUploadFilesize()) + " Mib has been reached");
        this.getChildren().addAll((Object[])new Node[]{warningLabel});
        grid.add((Node)this.populateFileList(), 0, 1, 2, 1);
        this.getChildren().add((Object)grid);
    }

    private ListView populateFileList() {
        ListView listView = new ListView();
        listView.setPrefSize(600.0, 200.0);
        ColumnConstraints colImage = new ColumnConstraints(16.0, 16.0, 16.0);
        ColumnConstraints colTitle = new ColumnConstraints(100.0, 300.0, Double.MAX_VALUE);
        for (File item : this.errorFiles) {
            GridPane grid = new GridPane();
            grid.setVgap(2.0);
            grid.setHgap(20.0);
            grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{colImage, colTitle});
            Image img = FileManagerUtils.getImageByType("file");
            ImageView view = new ImageView(img);
            view.setPreserveRatio(true);
            grid.add((Node)view, 0, 0);
            Label title = new Label(item.getName());
            title.setId("listText");
            grid.add((Node)title, 1, 0);
            listView.getItems().add((Object)grid);
        }
        return listView;
    }

    private void init() {
        this.setId("ProxyDialog");
        this.setAlignment(Pos.CENTER);
        this.setSpacing(5.0);
        this.setMaxSize(600.0, Double.NEGATIVE_INFINITY);
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                t.consume();
            }
        });
        Label title = new Label("Upload Limit Reached");
        title.setId("title");
        title.setMinHeight(22.0);
        title.setPrefHeight(22.0);
        title.setMaxWidth(Double.MAX_VALUE);
        title.setAlignment(Pos.CENTER);
        this.getChildren().addAll((Object[])new Node[]{title});
    }
}

