/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.dialog;

import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.controller.MainController;
import de.ilias.services.filemanager.soap.SoapClientConnector;
import de.ilias.services.filemanager.soap.SoapClientConnectorException;
import de.ilias.services.filemanager.soap.api.SoapClientFile;
import de.ilias.services.filemanager.soap.api.SoapClientFileContent;
import de.ilias.services.filemanager.soap.api.SoapClientFileLock;
import de.ilias.services.filemanager.utils.FileManagerUtils;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class RevisionStateDialog
extends VBox {
    protected static final int PARSE_DAYS = 1;
    protected static final int PARSE_HOURS = 2;
    protected static final int PARSE_MINUTES = 3;
    protected static final Logger logger = Logger.getLogger(RevisionStateDialog.class.getName());
    private ListItem item = null;
    private SoapClientFile file = null;

    public RevisionStateDialog(ListItem item) {
        this.item = item;
        this.initFile();
        this.init();
    }

    public ListItem getListItem() {
        return this.item;
    }

    public SoapClientFileLock getFileLock() {
        return this.file.getFileLock();
    }

    public SoapClientFile getFile() {
        return this.file;
    }

    public void parse() {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(12.0);
        grid.getColumnConstraints().add((Object)new ColumnConstraints(20.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(20.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(500.0));
        final CheckBox rs = new CheckBox();
        final RadioButton unlimited = new RadioButton();
        final RadioButton limited = new RadioButton();
        final CheckBox download = new CheckBox();
        ToggleGroup tg = new ToggleGroup();
        final HBox hbox = new HBox(6.0);
        boolean defaultEnabled = FileManagerUtils.textToInt(this.getFileLock().getUserId()) > 0;
        rs.setText("Set \"In Revision\"");
        rs.setIndeterminate(false);
        rs.setSelected(defaultEnabled);
        logger.info(this.getFileLock().getUserId());
        rs.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                if (!newVal.booleanValue()) {
                    unlimited.setDisable(true);
                    limited.setDisable(true);
                    download.setDisable(true);
                    hbox.setDisable(true);
                } else {
                    unlimited.setDisable(false);
                    limited.setDisable(false);
                    download.setDisable(false);
                    hbox.setDisable(false);
                }
                if (newVal.booleanValue() && !oldVal.booleanValue() && !unlimited.isSelected() && !limited.isSelected()) {
                    unlimited.setSelected(true);
                }
            }
        });
        grid.add((Node)rs, 0, 0, 3, 1);
        final Label warningLabel = new Label();
        warningLabel.setId("warning");
        warningLabel.setAlignment(Pos.CENTER);
        warningLabel.setVisible(false);
        this.getChildren().addAll((Object[])new Node[]{warningLabel});
        unlimited.setText("Unlimited");
        unlimited.setToggleGroup(tg);
        unlimited.setSelected(this.getFileLock().getUntil().equals("-1"));
        unlimited.setDisable(!defaultEnabled);
        grid.add((Node)unlimited, 1, 1, 2, 1);
        limited.setText("Limited");
        limited.setToggleGroup(tg);
        limited.setSelected(FileManagerUtils.textToInt(this.getFileLock().getUntil()) > 0);
        limited.setDisable(!defaultEnabled);
        grid.add((Node)limited, 1, 2, 2, 1);
        hbox.getChildren().addAll((Object[])new Node[]{new Label("Days:")});
        final TextField days = new TextField();
        days.setText(this.parseDuration(1, this.getFileLock().getRemainingSeconds()));
        days.setPromptText("0");
        days.setPrefColumnCount(2);
        hbox.getChildren().addAll((Object[])new Node[]{days});
        hbox.getChildren().addAll((Object[])new Node[]{new Label("Hours:")});
        final TextField hours = new TextField();
        hours.setText(this.parseDuration(2, this.getFileLock().getRemainingSeconds()));
        hours.setPromptText("0");
        hours.setPrefColumnCount(2);
        hbox.getChildren().addAll((Object[])new Node[]{hours});
        hbox.getChildren().addAll((Object[])new Node[]{new Label("Minutes:")});
        final TextField min = new TextField();
        min.setText(this.parseDuration(3, this.getFileLock().getRemainingSeconds()));
        min.setPromptText("0");
        min.setPrefColumnCount(2);
        hbox.getChildren().addAll((Object[])new Node[]{min});
        hbox.setDisable(!defaultEnabled);
        grid.add((Node)hbox, 2, 3, 1, 1);
        download.setText("Enable Download");
        download.setIndeterminate(false);
        download.setSelected(this.getFileLock().isDownloadEnabled());
        download.setDisable(!defaultEnabled);
        grid.add((Node)download, 1, 4, 2, 1);
        Button cancel = new Button("Cancel");
        cancel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                MainController.getInstance().hideModalDialog();
                me.consume();
            }
        });
        Button submit = new Button("Save");
        submit.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public synchronized void handle(MouseEvent me) {
                long durationSeconds = Integer.valueOf(FileManagerUtils.textToInt(days.getText())) * 24 * 60 * 60;
                durationSeconds += (long)(Integer.valueOf(FileManagerUtils.textToInt(hours.getText())) * 60 * 60);
                durationSeconds += (long)(Integer.valueOf(FileManagerUtils.textToInt(min.getText())) * 60);
                if (rs.isSelected()) {
                    logger.info("RS is checked!");
                    if (limited.isSelected()) {
                        logger.info("Limited is sleected");
                        if (durationSeconds <= 0L) {
                            warningLabel.setText("Please enter a valid duration.");
                            warningLabel.setVisible(true);
                            return;
                        }
                    }
                }
                if (!rs.isSelected()) {
                    logger.info("Deactivated file locking");
                    RevisionStateDialog.this.getFile().setFileLock(new SoapClientFileLock());
                } else {
                    RevisionStateDialog.this.getFileLock().setUserId(SoapClientConnector.getInstance(1).getUserId());
                    RevisionStateDialog.this.getFileLock().enableDownload(download.isSelected());
                    if (unlimited.isSelected()) {
                        RevisionStateDialog.this.getFileLock().setUntil(-1L);
                    } else {
                        RevisionStateDialog.this.getFileLock().setUntil(System.currentTimeMillis() / 1000L + durationSeconds);
                    }
                    RevisionStateDialog.this.getFile().setFileLock(RevisionStateDialog.this.getFileLock());
                }
                RevisionStateDialog.this.getFile().setContent(new SoapClientFileContent());
                SoapClientConnector con = SoapClientConnector.getInstance(1);
                con.updateFileMD(RevisionStateDialog.this.getFile(), RevisionStateDialog.this.getListItem().getRefId());
                MainController.getInstance().switchDirectory(RevisionStateDialog.this.getListItem().getParent());
                MainController.getInstance().hideModalDialog();
                me.consume();
            }
        });
        HBox buttonBox = new HBox();
        buttonBox.setSpacing(10.0);
        buttonBox.setAlignment(Pos.BOTTOM_RIGHT);
        buttonBox.getChildren().addAll((Object[])new Node[]{cancel, submit});
        grid.add((Node)buttonBox, 0, 5, 3, 1);
        this.getChildren().add((Object)grid);
    }

    private void init() {
        this.setId("ProxyDialog");
        this.setAlignment(Pos.CENTER);
        this.setSpacing(20.0);
        this.setMaxSize(600.0, Double.NEGATIVE_INFINITY);
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                t.consume();
            }
        });
        Label title = new Label("Edit Revision State");
        title.setId("title");
        title.setMinHeight(22.0);
        title.setPrefHeight(22.0);
        title.setMaxWidth(Double.MAX_VALUE);
        title.setAlignment(Pos.CENTER);
        this.getChildren().addAll((Object[])new Node[]{title});
    }

    private void initFile() {
        SoapClientConnector con = SoapClientConnector.getInstance(1);
        try {
            this.file = con.getFileXML(this.getListItem().getRefId());
        }
        catch (SoapClientConnectorException ex) {
            logger.severe(ex.getMessage());
        }
    }

    protected String parseDuration(int parseMode, long seconds) {
        long mod = 0L;
        long rest = 0L;
        if (seconds <= 0L) {
            return "";
        }
        if (parseMode == 1) {
            mod = seconds / 86400L;
        }
        if (parseMode == 2) {
            rest = seconds % 86400L;
            mod = rest / 3600L;
        }
        if (parseMode == 3) {
            rest = seconds % 86400L;
            mod = (rest %= 3600L) / 60L;
        }
        if (mod > 0L) {
            return String.valueOf(mod);
        }
        return "";
    }
}

