/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.dialog;

import de.ilias.services.filemanager.action.ActionHandler;
import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.content.RemoteListItem;
import de.ilias.services.filemanager.controller.MainController;
import de.ilias.services.filemanager.soap.SoapClientConnector;
import de.ilias.services.filemanager.soap.api.SoapClientFile;
import de.ilias.services.filemanager.soap.api.SoapClientObject;
import de.ilias.services.filemanager.soap.api.SoapClientObjects;
import de.ilias.services.filemanager.utils.FileManagerUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class PasteConflictDialog
extends VBox {
    private static final Logger logger = Logger.getLogger(PasteConflictDialog.class.getName());
    private final HashMap<ListItem, List<File>> conflictStack = new HashMap();
    private List<File> files;
    private HashMap<File, SoapClientObject> conflictFiles;
    private final ListItem targetObject;
    private SoapClientObjects targetObjects;

    public PasteConflictDialog(List<File> files, HashMap<File, SoapClientObject> conflictFiles, ListItem targetObject, SoapClientObjects targetObjects) {
        this.files = files;
        this.conflictFiles = conflictFiles;
        this.targetObject = targetObject;
        this.targetObjects = targetObjects;
        this.init();
    }

    public HashMap<ListItem, List<File>> getConflictStack() {
        return this.conflictStack;
    }

    public void parse() {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(12.0);
        Label warningLabel = new Label();
        warningLabel.setId("warning");
        warningLabel.setAlignment(Pos.CENTER);
        warningLabel.setVisible(true);
        warningLabel.setText("There are already file(s) with the same name at this location. Please choose one action.");
        this.getChildren().addAll((Object[])new Node[]{warningLabel});
        grid.add((Node)this.populateItemList(), 0, 1, 2, 1);
        final CheckBox checkboxNode = this.addSaveDecisionBox();
        grid.add((Node)checkboxNode, 0, 2, 2, 1);
        Button cancel = new Button("Cancel");
        cancel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                MainController.getInstance().hideModalDialog();
                me.consume();
            }
        });
        Button create = new Button("Create New Versions");
        create.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                boolean replaceAllSubitems = false;
                if (checkboxNode.isVisible() && checkboxNode.isSelected()) {
                    replaceAllSubitems = true;
                }
                for (Map.Entry entry : PasteConflictDialog.this.conflictFiles.entrySet()) {
                    if (((SoapClientObject)entry.getValue()).isContainer()) continue;
                    logger.info("Adding new file version for " + entry.getKey());
                    SoapClientFile file = new SoapClientFile();
                    file.setFilename(((File)entry.getKey()).getName());
                    file.setTitle(((File)entry.getKey()).getName());
                    file.getContent().setContentFile((File)entry.getKey());
                    SoapClientConnector con = SoapClientConnector.getInstance(1);
                    con.updateFile(file, ((SoapClientObject)entry.getValue()).getRefId());
                    PasteConflictDialog.this.files.remove(entry.getKey());
                }
                for (Map.Entry entry : PasteConflictDialog.this.conflictFiles.entrySet()) {
                    if (!((SoapClientObject)entry.getValue()).isContainer() || replaceAllSubitems) continue;
                    logger.info("Handling naming conflict");
                    if (this.handleRemoteNamingConflict((File)entry.getKey(), (SoapClientObject)entry.getValue())) {
                        // empty if block
                    }
                    PasteConflictDialog.this.files.remove(entry.getKey());
                }
                ActionHandler.copyFilesFromClipboardToRemote(PasteConflictDialog.this.targetObject, PasteConflictDialog.this.files, false);
                PasteConflictDialog.this.finishDialog(true);
                Clipboard clip = Clipboard.getSystemClipboard();
                ClipboardContent clipContent = new ClipboardContent();
                clipContent.clear();
            }

            private boolean handleRemoteNamingConflict(File source, SoapClientObject target) {
                logger.info("Handling source " + source.getPath());
                File[] files = source.listFiles();
                ArrayList<File> subFiles = new ArrayList<File>();
                if (files == null) {
                    return false;
                }
                for (File file : files) {
                    if (file.getName().equals("..") || file.getName().equals(".") || file.isHidden()) continue;
                    logger.info("Added " + file.getName());
                    subFiles.add(file);
                }
                if (subFiles.size() == 0) {
                    return false;
                }
                RemoteListItem targetItem = new RemoteListItem();
                targetItem.setParent(PasteConflictDialog.this.targetObject);
                targetItem.setRefId(target.getRefId());
                targetItem.setType(target.getType());
                targetItem.setTitle(target.getTitle());
                targetItem.setWritable(target.isWritable());
                targetItem.setReadable(target.isReadable());
                targetItem.setContainer(target.isContainer());
                if (ActionHandler.handleRemoteNamingConflict(targetItem, subFiles, false)) {
                    logger.info("Adding to stack");
                    PasteConflictDialog.this.conflictStack.put(targetItem, subFiles);
                    return true;
                }
                return false;
            }
        });
        Button replace = new Button("Create New Copy");
        replace.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                for (Map.Entry entry : PasteConflictDialog.this.conflictFiles.entrySet()) {
                    String newName = PasteConflictDialog.this.targetObjects.createUniqueName((File)entry.getKey());
                    if (!((SoapClientObject)entry.getValue()).isContainer()) {
                        logger.info("Adding new file version for " + entry.getKey());
                        SoapClientFile file = new SoapClientFile();
                        file.setFilename(newName);
                        file.setTitle(newName);
                        file.getContent().setContentFile((File)entry.getKey());
                        SoapClientConnector con = SoapClientConnector.getInstance(1);
                        con.addFile(file, PasteConflictDialog.this.targetObject.getRefId());
                        PasteConflictDialog.this.files.remove(entry.getKey());
                        continue;
                    }
                    String newType = "cat";
                    if (PasteConflictDialog.this.targetObject.getType().equals("crs") || PasteConflictDialog.this.targetObject.getType().equals("grp")) {
                        newType = "fold";
                    }
                    SoapClientObjects newObjs = new SoapClientObjects();
                    SoapClientObject newObject = new SoapClientObject();
                    newObject.setType(newType);
                    newObject.setTitle(newName);
                    newObjs.getObjects().add(newObject);
                    SoapClientConnector con = SoapClientConnector.getInstance(1);
                    int newRef = con.addObject(newObjs, PasteConflictDialog.this.targetObject.getRefId());
                    RemoteListItem newTarget = new RemoteListItem();
                    newTarget.setRefId(newRef);
                    newTarget.setTitle(newName);
                    newTarget.setType(newType);
                    newTarget.setContainer(true);
                    newTarget.setParent(PasteConflictDialog.this.targetObject);
                    ActionHandler.copyFilesFromClipboardToRemote(newTarget, Arrays.asList(((File)entry.getKey()).listFiles()), false);
                    PasteConflictDialog.this.files.remove(entry.getKey());
                }
                ActionHandler.copyFilesFromClipboardToRemote(PasteConflictDialog.this.targetObject, PasteConflictDialog.this.files, true);
                PasteConflictDialog.this.finishDialog(true);
            }
        });
        HBox buttonBox = new HBox();
        buttonBox.setSpacing(10.0);
        buttonBox.setAlignment(Pos.BOTTOM_RIGHT);
        buttonBox.getChildren().addAll((Object[])new Node[]{cancel, create, replace});
        grid.add((Node)buttonBox, 0, 3, 2, 1);
        this.getChildren().add((Object)grid);
    }

    private CheckBox addSaveDecisionBox() {
        boolean hasContainerConflict = false;
        CheckBox box = null;
        for (Map.Entry<File, SoapClientObject> entry : this.conflictFiles.entrySet()) {
            if (!entry.getValue().isContainer()) continue;
            hasContainerConflict = true;
        }
        box = new CheckBox("Remember my decision for all subitems.");
        box.setIndeterminate(false);
        box.setSelected(true);
        if (hasContainerConflict) {
            // empty if block
        }
        box.setVisible(false);
        return box;
    }

    private void finishDialog(boolean redirect) {
        MainController.getInstance().hideModalDialog();
        if (redirect) {
            if (this.targetObject.isContainer()) {
                MainController.getInstance().switchDirectory(this.targetObject);
            } else {
                MainController.getInstance().switchDirectory(this.targetObject.getParent());
            }
        }
        for (Map.Entry<ListItem, List<File>> entry : this.getConflictStack().entrySet()) {
            ActionHandler.handleRemoteNamingConflict(entry.getKey(), entry.getValue(), true);
        }
    }

    private ListView populateItemList() {
        ListView listView = new ListView();
        listView.setPrefSize(600.0, 200.0);
        ColumnConstraints colImage = new ColumnConstraints(16.0, 16.0, 16.0);
        ColumnConstraints colTitle = new ColumnConstraints(100.0, 300.0, Double.MAX_VALUE);
        for (Map.Entry<File, SoapClientObject> entry : this.conflictFiles.entrySet()) {
            GridPane grid = new GridPane();
            grid.setVgap(2.0);
            grid.setHgap(20.0);
            grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{colImage, colTitle});
            Image img = FileManagerUtils.getImageByType(entry.getValue().getType());
            ImageView view = new ImageView(img);
            view.setPreserveRatio(true);
            grid.add((Node)view, 0, 0);
            Label title = new Label(entry.getValue().getTitle());
            title.setId("listText");
            grid.add((Node)title, 1, 0);
            if (entry.getValue().getDescription().length() > 0) {
                Label description = new Label(entry.getValue().getDescription());
                description.setId("listTextDescription");
                description.setWrapText(false);
                grid.add((Node)description, 1, 1, 4, 1);
            }
            listView.getItems().add((Object)grid);
        }
        return listView;
    }

    private void init() {
        this.setId("ProxyDialog");
        this.setAlignment(Pos.CENTER);
        this.setSpacing(5.0);
        this.setMaxSize(600.0, Double.NEGATIVE_INFINITY);
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                t.consume();
            }
        });
        Label title = null;
        title = !this.targetObject.getTitle().equals("..") ? new Label("Copy Files to \"" + this.targetObject.getTitle() + "\"") : new Label("Copy Files");
        title.setId("title");
        title.setMinHeight(22.0);
        title.setPrefHeight(22.0);
        title.setMaxWidth(Double.MAX_VALUE);
        title.setAlignment(Pos.CENTER);
        this.getChildren().addAll((Object[])new Node[]{title});
    }
}

