/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.dialog;

import de.ilias.services.filemanager.action.ActionHandler;
import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.controller.MainController;
import de.ilias.services.filemanager.utils.FileManagerUtils;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class DeleteDialog
extends VBox {
    private ListItem item = null;

    public DeleteDialog(ListItem item) {
        this.item = item;
        this.init();
    }

    public ListItem getListItem() {
        return this.item;
    }

    public void parse() {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(12.0);
        Label warningLabel = new Label();
        warningLabel.setId("warning");
        warningLabel.setAlignment(Pos.CENTER);
        warningLabel.setVisible(true);
        warningLabel.setText("Do you really want to delete the following files and folders?");
        this.getChildren().addAll((Object[])new Node[]{warningLabel});
        Button cancel = new Button("Cancel");
        cancel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                MainController.getInstance().hideModalDialog();
                me.consume();
            }
        });
        Button submit = new Button("Delete");
        submit.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                ObservableList selectedItems = MainController.getInstance().getList(DeleteDialog.this.getListItem()).getSelectionModel().getSelectedItems();
                ArrayList<ListItem> items = new ArrayList<ListItem>();
                Iterator selected = selectedItems.iterator();
                while (selected.hasNext()) {
                    items.add((ListItem)((Node)selected.next()).getUserData());
                }
                if (ActionHandler.deleteItems(items)) {
                    // empty if block
                }
                MainController.getInstance().hideModalDialog();
                MainController.getInstance().switchDirectory(DeleteDialog.this.getListItem().getParent());
            }
        });
        HBox buttonBox = new HBox();
        buttonBox.setSpacing(10.0);
        buttonBox.setAlignment(Pos.BOTTOM_RIGHT);
        buttonBox.getChildren().addAll((Object[])new Node[]{cancel, submit});
        grid.add((Node)this.populateItemList(), 0, 1, 2, 1);
        grid.add((Node)buttonBox, 0, 2, 2, 1);
        this.getChildren().add((Object)grid);
    }

    private ListView populateItemList() {
        ListView listView = new ListView();
        listView.setPrefSize(600.0, 200.0);
        ColumnConstraints colImage = new ColumnConstraints(16.0, 16.0, 16.0);
        ColumnConstraints colTitle = new ColumnConstraints(100.0, 300.0, Double.MAX_VALUE);
        Iterator ite = MainController.getInstance().getList(this.getListItem()).getSelectionModel().getSelectedItems().iterator();
        while (ite.hasNext()) {
            ListItem item = (ListItem)((Node)ite.next()).getUserData();
            GridPane grid = new GridPane();
            grid.setVgap(2.0);
            grid.setHgap(20.0);
            grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{colImage, colTitle});
            Image img = FileManagerUtils.getImageByType(item.getType());
            ImageView view = new ImageView(img);
            view.setPreserveRatio(true);
            grid.add((Node)view, 0, 0);
            Label title = new Label(item.getTitle());
            title.setId("listText");
            grid.add((Node)title, 1, 0);
            if (item.getDescription().length() > 0) {
                Label description = new Label(item.getDescription());
                description.setId("listTextDescription");
                description.setWrapText(false);
                grid.add((Node)description, 1, 1, 4, 1);
            }
            listView.getItems().add((Object)grid);
        }
        return listView;
    }

    private void init() {
        this.setId("ProxyDialog");
        this.setAlignment(Pos.CENTER);
        this.setSpacing(5.0);
        this.setMaxSize(600.0, Double.NEGATIVE_INFINITY);
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                t.consume();
            }
        });
        Label title = new Label("Delete Files");
        title.setId("title");
        title.setMinHeight(22.0);
        title.setPrefHeight(22.0);
        title.setMaxWidth(Double.MAX_VALUE);
        title.setAlignment(Pos.CENTER);
        this.getChildren().addAll((Object[])new Node[]{title});
    }
}

