/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.dialog;

import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.content.LocalListItem;
import de.ilias.services.filemanager.content.RemoteListItem;
import de.ilias.services.filemanager.controller.MainController;
import de.ilias.services.filemanager.dialog.RenameDialog;
import de.ilias.services.filemanager.soap.SoapClientConnector;
import de.ilias.services.filemanager.soap.api.SoapClientObject;
import de.ilias.services.filemanager.soap.api.SoapClientObjects;
import de.ilias.services.filemanager.utils.FileManagerUtils;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextAreaBuilder;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFieldBuilder;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class CreateDialog
extends VBox {
    protected static final Logger logger = Logger.getLogger(RenameDialog.class.getName());
    private ListItem item = null;
    private int type;

    public CreateDialog(ListItem item, int type) {
        this.item = item;
        this.type = type;
        this.init();
    }

    public int getType() {
        return this.type;
    }

    public ListItem getListItem() {
        return this.item;
    }

    public void parse() {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(12.0);
        Label titleLabel = new Label("Title");
        final TextField title = ((TextFieldBuilder)TextFieldBuilder.create().prefColumnCount(40).editable(true)).build();
        final Label warningLabel = new Label();
        warningLabel.setId("warning");
        warningLabel.setAlignment(Pos.CENTER);
        warningLabel.setVisible(false);
        this.getChildren().addAll((Object[])new Node[]{warningLabel});
        Label descriptionLabel = null;
        final TextArea description = TextAreaBuilder.create().build();
        if (this.getListItem() instanceof RemoteListItem) {
            descriptionLabel = new Label("Description");
            String descriptionValue = " ";
            description.setText(descriptionValue);
            description.setEditable(true);
            description.setPrefColumnCount(40);
            description.setPrefRowCount(6);
        }
        Button cancel = new Button("Cancel");
        cancel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                MainController.getInstance().hideModalDialog();
                me.consume();
            }
        });
        Button submit = new Button("Save");
        submit.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){
            private boolean eventHandled = false;

            public void handle(MouseEvent me) {
                if (title.getText().trim().length() <= 0) {
                    warningLabel.setText("Please a enter a title.");
                    warningLabel.setVisible(true);
                    return;
                }
                if (this.eventHandled) {
                    me.consume();
                    return;
                }
                this.eventHandled = true;
                if (CreateDialog.this.getListItem() instanceof LocalListItem) {
                    // empty if block
                }
                if (CreateDialog.this.getListItem() instanceof RemoteListItem) {
                    SoapClientObjects objs = new SoapClientObjects();
                    SoapClientObject obj = new SoapClientObject();
                    obj.setType(FileManagerUtils.createTypeToILIASType(CreateDialog.this.getType()));
                    obj.setTitle(title.getText());
                    obj.setDescription(description.getText());
                    objs.getObjects().add(obj);
                    SoapClientConnector con = SoapClientConnector.getInstance(1);
                    if (con.addObject(objs, CreateDialog.this.getListItem().getRefId()) <= 0) {
                        warningLabel.setText("Could not create object. Please check your input.");
                        warningLabel.setVisible(true);
                        return;
                    }
                }
                MainController.getInstance().switchDirectory(CreateDialog.this.getListItem());
                MainController.getInstance().hideModalDialog();
                me.consume();
            }
        });
        HBox buttonBox = new HBox();
        buttonBox.setSpacing(10.0);
        buttonBox.setAlignment(Pos.BOTTOM_RIGHT);
        buttonBox.getChildren().addAll((Object[])new Node[]{cancel, submit});
        grid.add((Node)titleLabel, 0, 0);
        grid.add((Node)title, 1, 0);
        if (this.getListItem() instanceof RemoteListItem) {
            grid.add((Node)descriptionLabel, 0, 1);
            grid.add((Node)description, 1, 1);
        }
        grid.add((Node)buttonBox, 0, 2, 2, 1);
        this.getChildren().add((Object)grid);
    }

    private void init() {
        this.setId("ProxyDialog");
        this.setAlignment(Pos.CENTER);
        this.setSpacing(5.0);
        this.setMaxSize(600.0, Double.NEGATIVE_INFINITY);
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                t.consume();
            }
        });
        Label title = new Label();
        switch (this.type) {
            case 7: {
                title.setText("Create New Category");
                break;
            }
            case 8: {
                title.setText("Create New Course");
                break;
            }
            case 10: {
                title.setText("Create New Group");
                break;
            }
            case 9: {
                title.setText("Create New Folder");
            }
        }
        title.setId("title");
        title.setMinHeight(22.0);
        title.setPrefHeight(22.0);
        title.setMaxWidth(Double.MAX_VALUE);
        title.setAlignment(Pos.CENTER);
        this.getChildren().addAll((Object[])new Node[]{title});
    }
}

