/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.controller;

import de.ilias.services.filemanager.FileManager;
import de.ilias.services.filemanager.content.ContentFrameDirectoryStack;
import de.ilias.services.filemanager.content.DirectoryStackItem;
import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.content.ListItemReader;
import de.ilias.services.filemanager.content.ListViewItemParser;
import de.ilias.services.filemanager.content.LocalListItem;
import de.ilias.services.filemanager.content.RemoteListItem;
import de.ilias.services.filemanager.events.SearchKeyEventHandler;
import de.ilias.services.filemanager.layout.WindowManager;
import de.ilias.services.filemanager.skin.SkinFactory;
import de.ilias.services.filemanager.soap.SoapClientConnector;
import de.ilias.services.filemanager.soap.SoapClientConnectorException;
import de.ilias.services.filemanager.soap.api.SoapClientFile;
import de.ilias.services.filemanager.ui.BreadcrumbBuilder;
import java.awt.Desktop;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.TimelineBuilder;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class MainController
implements Initializable {
    private static MainController instance;
    protected static final Logger logger;
    private double windowDragOffsetX = 0.0;
    private double windowDragOffsetY = 0.0;
    @FXML
    private StackPane rootStack;
    @FXML
    private StackPane dialogStack;
    @FXML
    private BorderPane root;
    @FXML
    private Label label;
    @FXML
    private VBox windowButtons;
    @FXML
    private SplitPane contentSplitPane;
    @FXML
    private ListView remoteList;
    @FXML
    private ListView localList;
    private ListView remoteSearchList;
    @FXML
    private BorderPane localFrame;
    @FXML
    private BorderPane remoteFrame;
    @FXML
    private TextField search;
    @FXML
    private TabPane remoteTabs;
    @FXML
    private Tab remoteRepositoryTab;
    @FXML
    private ListView remoteBreadcrumb;
    private Tab remoteSearchTab = new Tab("Search Results");
    @FXML
    private Label mainTitle;

    public static MainController getInstance() {
        return instance;
    }

    public BorderPane getRoot() {
        return this.root;
    }

    public ListView getRemoteList() {
        return this.remoteList;
    }

    public ListView getLocalList() {
        return this.localList;
    }

    public ListView getRemoteSearchList() {
        return this.remoteSearchList;
    }

    public ListView getList(ListItem item) {
        if (item instanceof LocalListItem) {
            return this.getLocalList();
        }
        if (this.getRemoteSearchTab().isSelected()) {
            return this.getRemoteSearchList();
        }
        return this.getRemoteList();
    }

    public TextField getSearch() {
        return this.search;
    }

    public TabPane getRemoteTabPane() {
        return this.remoteTabs;
    }

    public Tab getRemoteRepositoryTab() {
        return this.remoteRepositoryTab;
    }

    public ListView getRemoteBreadcrumb() {
        return this.remoteBreadcrumb;
    }

    public Label getMainTitle() {
        return this.mainTitle;
    }

    public Tab getRemoteSearchTab() {
        return this.remoteSearchTab;
    }

    @FXML
    private void handleButtonAction(ActionEvent event) {
        logger.fine("New skin!");
        SkinFactory.switchSkin(FileManager.getInstance().getStage());
    }

    @FXML
    private void windowMoveInit(MouseEvent event) {
        WindowManager.getInstance().storePosition(event);
    }

    @FXML
    private void windowMove(MouseEvent event) {
        WindowManager.getInstance().move(event);
    }

    @FXML
    private void windowToggleOnDoubleClick(MouseEvent event) {
        if (event.getClickCount() == 2) {
            WindowManager.getInstance().toggle();
        }
    }

    @FXML
    private void windowClose(ActionEvent event) {
        WindowManager.getInstance().close();
    }

    @FXML
    private void windowMinimize(ActionEvent event) {
        WindowManager.getInstance().inconify();
    }

    @FXML
    private void windowToggle(ActionEvent event) {
        WindowManager.getInstance().toggle();
    }

    public void initialize(URL url, ResourceBundle rb) {
        System.out.println("Trying to disable vbox");
        instance = this;
        if (FileManager.getInstance().isApplet()) {
            this.windowButtons.setVisible(false);
        }
        this.initializeContentSplitPane();
        this.initializeRemoteList();
        this.initializeLocalList();
        this.initializeSearch();
    }

    protected void initializeContentSplitPane() {
    }

    protected void initializeRemoteList() {
        this.remoteBreadcrumb.getItems().add((Object)new Label());
        this.remoteBreadcrumb.setMinHeight(40.0);
        this.remoteBreadcrumb.setMaxHeight(50.0);
        this.remoteBreadcrumb.setEditable(false);
        this.remoteBreadcrumb.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.remoteBreadcrumb.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                me.consume();
            }
        });
        this.remoteList.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.remoteList.setPrefHeight(1280.0);
        this.remoteList.setId("contentListView");
    }

    protected void initializeLocalList() {
        this.localList.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.localList.setId("contentListView");
    }

    protected void initializeSearch() {
        this.getSearch().setOnKeyReleased((EventHandler)new SearchKeyEventHandler());
    }

    public void populateRemoteList(ObservableList listItems) {
        this.remoteList.setItems(listItems);
    }

    public void populateLocalList(ObservableList listItems) {
        this.localList.setItems(listItems);
    }

    public void populateSearchList(ObservableList listItems) {
        this.remoteSearchTab.setClosable(true);
        this.remoteSearchList = new ListView();
        this.remoteSearchList.setItems(listItems);
        this.remoteSearchTab.setContent((Node)this.remoteSearchList);
        if (this.getRemoteTabPane().getTabs().size() == 1) {
            this.getRemoteTabPane().getTabs().add((Object)this.remoteSearchTab);
        }
        this.getRemoteTabPane().getSelectionModel().select((Object)this.remoteSearchTab);
    }

    public void switchDirectory(ListItem item) {
        if (item instanceof LocalListItem) {
            logger.info("Switching to local node");
            DirectoryStackItem current = new DirectoryStackItem();
            if (item.getAbsolutePath() != null) {
                current.setType(1);
                current.setFile(new File(item.getAbsolutePath()));
            } else {
                current.setType(3);
            }
            ContentFrameDirectoryStack dirStack = ContentFrameDirectoryStack.getInstance();
            dirStack.getLocalStack().add(current);
            ListItemReader reader = new ListItemReader();
            try {
                reader.read(1);
            }
            catch (SoapClientConnectorException ex) {
                logger.severe("Cannote read content " + ex.getMessage());
            }
            ListViewItemParser parser = new ListViewItemParser(1);
            parser.setListItems(reader.getListItems());
            parser.sort();
            MainController.getInstance().populateLocalList(parser.parse());
        }
        if (item instanceof RemoteListItem) {
            int targetId = item.getRefId();
            logger.info("Switching to remote node with id " + item.getRefId());
            DirectoryStackItem current = new DirectoryStackItem();
            current.setType(2);
            current.setId(targetId);
            ContentFrameDirectoryStack dirStack = ContentFrameDirectoryStack.getInstance();
            dirStack.getRemoteStack().add(current);
            ListItemReader reader = new ListItemReader();
            try {
                reader.read(2);
            }
            catch (SoapClientConnectorException ex) {
                logger.severe("Cannote read content " + ex.getMessage());
            }
            ListViewItemParser parser = new ListViewItemParser(2);
            parser.setListItems(reader.getListItems());
            parser.sort();
            this.populateRemoteList(parser.parse());
            this.fillBreadcrumb(reader);
            this.getRemoteTabPane().getSelectionModel().select((Object)this.getRemoteRepositoryTab());
        }
    }

    public void fillBreadcrumb(ListItemReader reader) {
        BreadcrumbBuilder builder = new BreadcrumbBuilder();
        HBox box = new HBox();
        if (reader.getObjects() != null) {
            box = builder.buildHBox(reader.getObjects().getFirstPath(true));
        }
        this.getRemoteBreadcrumb().getItems().remove(0, this.getRemoteBreadcrumb().getItems().size());
        this.getRemoteBreadcrumb().getItems().add((Object)box);
    }

    public void deliverRemoteItem(ListItem item) {
        if (item.getType().equals("file")) {
            SoapClientConnector con = SoapClientConnector.getInstance();
            try {
                SoapClientFile fileXml = con.getFileXML(item.getRefId());
                File tmpFile = fileXml.writeToTempFile();
                Desktop desktop = Desktop.getDesktop();
                desktop.open(tmpFile);
            }
            catch (SoapClientConnectorException ex) {
                ex.printStackTrace();
                logger.severe("Cannot deliver file " + ex.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.severe("Cannot deliver file " + e.getMessage());
            }
        }
    }

    public void initModalDialog() {
        this.dialogStack.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                me.consume();
                MainController.this.hideModalDialog();
            }
        });
        this.dialogStack.setVisible(false);
    }

    public void showModalDialog(Node dialog) {
        this.dialogStack.getChildren().add((Object)dialog);
        this.dialogStack.setOpacity(0.0);
        this.dialogStack.setVisible(true);
        TimelineBuilder.create().keyFrames(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
            }
        }, new KeyValue[]{new KeyValue((WritableValue)this.dialogStack.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}).build().play();
    }

    public void hideModalDialog() {
        TimelineBuilder.create().keyFrames(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                MainController.this.dialogStack.getChildren().remove(0);
                if (MainController.this.dialogStack.getChildren().size() == 0) {
                    MainController.this.dialogStack.setVisible(false);
                }
            }
        }, new KeyValue[]{new KeyValue((WritableValue)this.dialogStack.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)})}).build().play();
    }

    public void switchOneFrame() {
        this.contentSplitPane.getItems().remove((Object)this.localFrame);
    }

    static {
        logger = Logger.getLogger(MainController.class.getName());
    }
}

