/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.content;

import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.content.ListItemProperty;
import de.ilias.services.filemanager.controller.MainController;
import de.ilias.services.filemanager.events.ListItemDragEventHandler;
import de.ilias.services.filemanager.events.ListItemKeyEventHandler;
import de.ilias.services.filemanager.events.ListItemMouseEventHandler;
import de.ilias.services.filemanager.utils.FileManagerUtils;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.text.Text;

public class ListViewItemParser {
    protected static final Logger logger = Logger.getLogger(ListViewItemParser.class.getName());
    private int currentFrame;
    private GridPane grid;
    private ArrayList<ListItem> items;

    public ListViewItemParser(int frame) {
        this.currentFrame = frame;
    }

    public void setListItems(ArrayList<ListItem> items) {
        this.items = items;
    }

    public void sort() {
        Collections.sort(this.getListItems());
    }

    public ArrayList<ListItem> getListItems() {
        return this.items;
    }

    public ObservableList parse() {
        if (this.currentFrame == 1) {
            return this.parseLocalList();
        }
        return this.parseRemoteList();
    }

    private ObservableList parseLocalList() {
        ObservableList listItems = FXCollections.observableArrayList();
        ColumnConstraints colImage = new ColumnConstraints(16.0, 16.0, 16.0);
        ColumnConstraints colTitle = new ColumnConstraints(100.0, 100.0, Double.MAX_VALUE);
        colTitle.setHgrow(Priority.ALWAYS);
        ColumnConstraints colType = new ColumnConstraints(50.0, 50.0, 100.0);
        ColumnConstraints colSize = new ColumnConstraints(75.0, 75.0, 100.0);
        colSize.setHalignment(HPos.RIGHT);
        Iterator<ListItem> ite = this.getListItems().iterator();
        int counter = 0;
        while (ite.hasNext()) {
            ListItem item = ite.next();
            if (counter++ == 0) {
                this.addListViewHandlers(item);
            }
            this.grid = new GridPane();
            this.grid.setUserData((Object)item);
            ListItemMouseEventHandler mouseEventHandler = new ListItemMouseEventHandler(item, (Node)this.grid);
            ListItemDragEventHandler dragEventHandler = new ListItemDragEventHandler(item);
            this.grid.setOnMouseClicked((EventHandler)mouseEventHandler);
            this.grid.setOnMousePressed((EventHandler)mouseEventHandler);
            this.grid.setOnDragDetected((EventHandler)mouseEventHandler);
            this.grid.setOnMouseReleased((EventHandler)mouseEventHandler);
            this.grid.setOnDragDropped((EventHandler)dragEventHandler);
            this.grid.setOnDragEntered((EventHandler)dragEventHandler);
            this.grid.setOnDragExited((EventHandler)dragEventHandler);
            this.grid.setOnDragOver((EventHandler)dragEventHandler);
            this.grid.setOnDragDone((EventHandler)dragEventHandler);
            this.grid.setVgap(2.0);
            this.grid.setHgap(20.0);
            this.grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{colImage, colTitle, colType, colSize});
            Image img = FileManagerUtils.getImageByType(item.getType());
            ImageView view = new ImageView(img);
            view.setPreserveRatio(true);
            this.grid.add((Node)view, 0, 0);
            if (item.isReadable()) {
                // empty if block
            }
            Label title = new Label(item.getTitle());
            title.setId("listText");
            this.grid.add((Node)title, 1, 0);
            Label type = new Label(item.getFileType());
            type.setId("listText");
            this.grid.add((Node)type, 2, 0);
            Label size = new Label(item.getReadableFileSize());
            size.setId("listText");
            this.grid.add((Node)size, 3, 0);
            Label modified = new Label();
            if (item.getLastUpdate() != null) {
                modified.setText(DateFormat.getDateTimeInstance(2, 3).format(item.getLastUpdate()));
            }
            modified.setId("listText");
            this.grid.add((Node)modified, 4, 0);
            if (item.getDescription().length() > 0) {
                Label description = new Label(item.getDescription());
                description.setId("listTextDescription");
                description.setWrapText(false);
                this.grid.add((Node)description, 1, 1, 4, 1);
            }
            listItems.add((Object)this.grid);
        }
        return listItems;
    }

    private ObservableList parseRemoteList() {
        ObservableList listItems = FXCollections.observableArrayList();
        ColumnConstraints colImage = new ColumnConstraints(16.0, 16.0, 16.0);
        ColumnConstraints colTitle = new ColumnConstraints(100.0, 200.0, Double.MAX_VALUE);
        colTitle.setHgrow(Priority.ALWAYS);
        ColumnConstraints colType = new ColumnConstraints(30.0, 30.0, 100.0);
        ColumnConstraints colSize = new ColumnConstraints(30.0, 60.0, 100.0);
        colSize.setHalignment(HPos.RIGHT);
        Iterator<ListItem> ite = this.getListItems().iterator();
        int counter = 0;
        while (ite.hasNext()) {
            ListItem item = ite.next();
            if (counter++ == 0) {
                if (item.isUpperLink()) {
                    this.addListViewHandlers(item);
                } else {
                    this.addListViewHandlers(item.getParent());
                }
            }
            this.grid = new GridPane();
            this.grid.setId("listViewGrid");
            this.grid.setUserData((Object)item);
            ListItemMouseEventHandler mouseEventHandler = new ListItemMouseEventHandler(item, (Node)this.grid);
            ListItemDragEventHandler dragEventHandler = new ListItemDragEventHandler(item);
            this.grid.setOnMouseClicked((EventHandler)mouseEventHandler);
            this.grid.setOnMousePressed((EventHandler)mouseEventHandler);
            this.grid.setOnDragDetected((EventHandler)mouseEventHandler);
            this.grid.setOnDragDropped((EventHandler)dragEventHandler);
            this.grid.setOnDragEntered((EventHandler)dragEventHandler);
            this.grid.setOnDragExited((EventHandler)dragEventHandler);
            this.grid.setOnDragOver((EventHandler)dragEventHandler);
            this.grid.setOnDragDone((EventHandler)dragEventHandler);
            this.grid.setVgap(2.0);
            this.grid.setHgap(20.0);
            this.grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{colImage, colTitle, colType, colSize});
            Image img = FileManagerUtils.getImageByType(item.getType());
            ImageView view = new ImageView(img);
            view.setPreserveRatio(true);
            this.grid.add((Node)view, 0, 0);
            if (item.isReadable()) {
                // empty if block
            }
            Text title = new Text(item.getTitle());
            title.setId("listText");
            this.grid.add((Node)title, 1, 0);
            title = new Text(item.getFileType());
            title.setId("listText");
            this.grid.add((Node)title, 2, 0);
            Label size = new Label(item.getReadableFileSize());
            size.setId("listText");
            this.grid.add((Node)size, 3, 0);
            Label modified = new Label();
            if (item.getLastUpdate() != null) {
                modified.setText(DateFormat.getDateTimeInstance(2, 3).format(item.getLastUpdate()));
            }
            modified.setId("listText");
            this.grid.add((Node)modified, 4, 0);
            Label perm = new Label(item.getPermissions());
            perm.setId("listText");
            this.grid.add((Node)perm, 5, 0);
            if (item.getDescription().length() > 0) {
                Label description = new Label(item.getDescription());
                description.setId("listTextDescription");
                description.setWrapText(false);
                this.grid.add((Node)description, 1, 1, 3, 1);
            }
            if (item.getProperties().size() > 0) {
                int row = 2;
                for (ListItemProperty prop : item.getProperties()) {
                    if (prop.toString().length() <= 0) continue;
                    Label propT = new Label(prop.toString());
                    propT.setId("listTextProperty");
                    propT.setWrapText(false);
                    this.grid.add((Node)propT, 1, row, 3, 1);
                    ++row;
                }
            }
            listItems.add((Object)this.grid);
        }
        return listItems;
    }

    protected void addListViewHandlers(ListItem item) {
        ListView view = MainController.getInstance().getList(item);
        view.setUserData((Object)item);
        view.setOnMousePressed((EventHandler)new ListItemMouseEventHandler(item, (Node)view));
        ListItemKeyEventHandler keyEventHandler = new ListItemKeyEventHandler(item);
        view.setOnKeyPressed((EventHandler)keyEventHandler);
        view.setOnKeyReleased((EventHandler)keyEventHandler);
        view.setOnKeyTyped((EventHandler)keyEventHandler);
        ListItemDragEventHandler dragEventHandler = new ListItemDragEventHandler(item);
        view.setOnDragDropped((EventHandler)dragEventHandler);
        view.setOnDragEntered((EventHandler)dragEventHandler);
        view.setOnDragExited((EventHandler)dragEventHandler);
        view.setOnDragOver((EventHandler)dragEventHandler);
        view.setOnDragDone((EventHandler)dragEventHandler);
    }
}

