/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.content;

import de.ilias.services.filemanager.FileManager;
import de.ilias.services.filemanager.content.ContentFrameDirectoryStack;
import de.ilias.services.filemanager.content.DirectoryStackItem;
import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.content.ListItemProperty;
import de.ilias.services.filemanager.content.LocalListItem;
import de.ilias.services.filemanager.content.RemoteListItem;
import de.ilias.services.filemanager.soap.SoapClientConnector;
import de.ilias.services.filemanager.soap.SoapClientConnectorException;
import de.ilias.services.filemanager.soap.api.SoapClientObject;
import de.ilias.services.filemanager.soap.api.SoapClientObjectProperty;
import de.ilias.services.filemanager.soap.api.SoapClientObjectReference;
import de.ilias.services.filemanager.soap.api.SoapClientObjects;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;

public class ListItemReader {
    private static final Logger logger = Logger.getLogger(ListItemReader.class.getName());
    private int source = 0;
    private ListItem parent = null;
    private ArrayList<ListItem> items = new ArrayList();
    private SoapClientObjects objs;

    public ArrayList<ListItem> getListItems() {
        return this.items;
    }

    public void read(int sourceType) throws SoapClientConnectorException {
        this.source = sourceType;
        if (this.source == 2) {
            this.readRemote();
        } else {
            this.readLocal();
        }
    }

    public void setObjects(SoapClientObjects objs) {
        this.objs = objs;
    }

    public SoapClientObjects getObjects() {
        return this.objs;
    }

    private void readRemote() throws SoapClientConnectorException {
        ContentFrameDirectoryStack idStack = ContentFrameDirectoryStack.getInstance();
        int id = idStack.getRemoteStack().peek().getId();
        this.readRemoteContainer(id, true);
    }

    private void readLocal() {
        ContentFrameDirectoryStack dirStack = ContentFrameDirectoryStack.getInstance();
        DirectoryStackItem dirStackItem = dirStack.getLocalStack().peek();
        if (dirStackItem.getType() == 1) {
            logger.info("Reading local files");
            this.readLocalDir(dirStackItem.getFile());
        } else {
            logger.info("Reading local roots");
            this.readLocalRoots();
        }
    }

    private void readLocalDir(File dir) {
        logger.info(new StringBuffer("Current directory is ").append(dir.getAbsolutePath()).toString());
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        this.parent = new LocalListItem();
        this.parent.setAbsolutePath(dir.getAbsolutePath());
        this.parent.setTitle("..");
        this.parent.setFileSize(0L);
        this.parent.setType("cat");
        this.parent.setReadable(dir.canRead());
        this.parent.setWritable(dir.canWrite());
        this.parent.setContainer(true);
        File parent = dir.getParentFile();
        if (parent != null) {
            LocalListItem listItem = new LocalListItem();
            listItem.setParent(this.parent);
            listItem.setAbsolutePath(parent.getAbsolutePath());
            listItem.setTitle("..");
            listItem.setFileSize(0L);
            listItem.setType("cat");
            listItem.setReadable(parent.canRead());
            listItem.setWritable(parent.canWrite());
            listItem.setContainer(true);
            this.getListItems().add(listItem);
        } else if (this.isARoot(dir)) {
            LocalListItem listItem = new LocalListItem();
            listItem.setAbsolutePath(null);
            logger.info(new StringBuffer("Upper directory is ").append(listItem.getAbsolutePath()).toString());
            listItem.setTitle("..");
            listItem.setFileSize(0L);
            listItem.setType("cat");
            listItem.setReadable(true);
            listItem.setWritable(false);
            listItem.setContainer(true);
            this.getListItems().add(listItem);
        }
        this.parseLocalFiles(files, false);
    }

    private void parseLocalFiles(File[] files, boolean absoluteName) {
        for (int i = 0; i < files.length; ++i) {
            String fileName = absoluteName ? files[i].toString() : files[i].getName();
            logger.finer(fileName);
            if (files[i].isHidden() && !this.isARoot(files[i])) {
                logger.finer("...is Hidden");
                continue;
            }
            if (fileName.substring(0, 1).compareTo(".") == 0) {
                logger.finer("...is dot");
                continue;
            }
            LocalListItem listItem = new LocalListItem();
            listItem.setParent(this.parent);
            listItem.setAbsolutePath(files[i].getAbsolutePath());
            listItem.setTitle(fileName);
            listItem.setFileSize(files[i].length());
            listItem.setLastUpdate(new Date(files[i].lastModified()));
            int dot = files[i].getName().lastIndexOf(".");
            if (dot > 0) {
                listItem.setFileType(files[i].getName().substring(dot + 1));
            }
            if (files[i].isDirectory()) {
                listItem.setType("cat");
            } else {
                listItem.setType("file");
            }
            if (files[i].canRead() && files[i].canWrite()) {
                listItem.setPermissions("RW");
            } else if (files[i].canRead()) {
                listItem.setPermissions("R_");
            } else if (files[i].canWrite()) {
                listItem.setPermissions("W_");
            }
            listItem.setReadable(files[i].canRead());
            listItem.setWritable(files[i].canWrite());
            listItem.setContainer(files[i].isDirectory());
            this.getListItems().add(listItem);
        }
    }

    private void readLocalRoots() {
        File[] roots = File.listRoots();
        this.parseLocalFiles(roots, true);
    }

    private boolean isARoot(File dir) {
        File[] roots = File.listRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (!roots[i].getAbsolutePath().equals(dir.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public void readRemoteContainer(int refId, boolean withParent) throws SoapClientConnectorException {
        SoapClientObjects objects;
        boolean emptyContainer = false;
        if (this.getObjects() == null) {
            SoapClientConnector soap = SoapClientConnector.getInstance();
            objects = soap.getTreeChilds(refId);
            this.setObjects(objects);
        } else {
            objects = this.getObjects();
        }
        ListItem parent = objects.getParentListItem();
        RemoteListItem container = null;
        if (emptyContainer) {
            return;
        }
        Iterator<SoapClientObject> objectIte = objects.getObjects().iterator();
        boolean first = true;
        while (objectIte.hasNext()) {
            SoapClientObject object = objectIte.next();
            RemoteListItem listItem = new RemoteListItem();
            try {
                listItem.setFileSize(Long.parseLong(object.getPropertyByName("fileSize")));
            }
            catch (NumberFormatException e) {
                listItem.setFileSize(0L);
            }
            listItem.setDescription(object.getDescription());
            listItem.setRefId(object.getRefId());
            listItem.setObjId(object.getObjId());
            listItem.setType(object.getType());
            listItem.setFileType(object.getPropertyByName("fileExtension"));
            if (object.getPropertyByName("fileVersion").length() > 0) {
                ListItemProperty prop = new ListItemProperty();
                prop.setName("fileVersion");
                prop.setValue(object.getPropertyByName("fileVersion"));
                listItem.getProperties().add(prop);
            }
            for (SoapClientObjectProperty objProp : object.getPropertiesByName("info")) {
                ListItemProperty prop = new ListItemProperty();
                prop.setName("info");
                prop.setValue(objProp.getValue());
                listItem.getProperties().add(prop);
            }
            listItem.setLastUpdate(object.getLastUpdate());
            for (SoapClientObjectReference references : object.getReferences()) {
                for (String operation : references.getOperations()) {
                    if (operation.equalsIgnoreCase("write")) {
                        listItem.setWritable(true);
                    }
                    if (operation.equalsIgnoreCase("read")) {
                        listItem.setReadable(true);
                    }
                    if (operation.equalsIgnoreCase("delete")) {
                        listItem.setDeletable(true);
                    }
                    if (operation.equalsIgnoreCase("create_cat")) {
                        listItem.setCategoryAllowed(true);
                    }
                    if (operation.equalsIgnoreCase("create_crs")) {
                        listItem.setCourseAllowed(true);
                    }
                    if (operation.equalsIgnoreCase("create_fold")) {
                        listItem.setFolderAllowed(true);
                    }
                    if (!operation.equalsIgnoreCase("create_grp")) continue;
                    listItem.setGroupAllowed(true);
                }
            }
            if (FileManager.getInstance().enabledFileLocks() && listItem.getType().equalsIgnoreCase("file") && !object.getPropertyByName("fileAccess").equalsIgnoreCase("1")) {
                listItem.setReadable(false);
            }
            listItem.setContainer(object.isContainer());
            if (first) {
                listItem.setTitle("..");
                listItem.setDescription("");
                listItem.setUpperLink(true);
                listItem.setParent(parent);
                parent = listItem;
                container = listItem;
                first = false;
            } else {
                listItem.setParent(container);
                listItem.setTitle(object.getTitle());
            }
            if (listItem.getRefId() == 1 || listItem.isUpperLink() && !withParent) continue;
            this.getListItems().add(listItem);
        }
    }
}

