/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.content;

import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.content.LocalListItem;
import de.ilias.services.filemanager.content.RemoteListItem;
import de.ilias.services.filemanager.events.ListItemContextMenuEventHandler;
import de.ilias.services.filemanager.utils.FileManagerUtils;
import java.util.ArrayList;
import java.util.logging.Logger;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.MenuItemBuilder;
import javafx.scene.control.SeparatorMenuItemBuilder;
import javafx.scene.image.ImageViewBuilder;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class ListItemActionContextMenu
extends ContextMenu {
    private static final Logger logger = Logger.getLogger(ListItemActionContextMenu.class.getName());
    private ObservableList<Node> selected = null;
    private Node source = null;
    private ArrayList<ListItem> listItems = new ArrayList();
    private boolean allowOpen = false;
    private boolean allowCopy = false;
    private boolean allowPaste = false;
    private boolean allowDelete = false;
    private boolean allowRename = false;
    private boolean allowCopyToClipboard = false;
    private boolean allowCreate = false;
    private boolean allowCourse = false;
    private boolean allowFolder = false;
    private boolean allowCategory = false;
    private boolean allowGroup = false;

    public ListItemActionContextMenu(ObservableList<Node> sel, Node source) {
        this.selected = sel;
        this.source = source;
        this.parseSelected();
        this.populate();
    }

    public ObservableList<Node> getSelectedNodes() {
        return this.selected;
    }

    public ArrayList<ListItem> getSelectedItems() {
        return this.listItems;
    }

    public Node getSource() {
        return this.source;
    }

    protected void parseSelected() {
        Clipboard clip;
        boolean multipleSelected;
        if (this.getSelectedNodes().size() > 1) {
            multipleSelected = true;
            this.allowCreate = false;
            this.allowOpen = false;
            this.allowCopy = true;
            this.allowCopyToClipboard = true;
            this.allowPaste = false;
            this.allowRename = false;
            this.allowDelete = true;
        } else {
            multipleSelected = false;
            this.allowOpen = true;
            this.allowCopy = true;
            this.allowCopyToClipboard = true;
            this.allowRename = true;
            this.allowPaste = true;
            this.allowDelete = true;
        }
        for (Node node : this.getSelectedNodes()) {
            ListItem listItem = (ListItem)node.getUserData();
            this.getSelectedItems().add(listItem);
            if (listItem instanceof RemoteListItem && this.getSelectedNodes().size() == 1 && (listItem.getType().equals("crs") || listItem.getType().equals("grp"))) {
                this.allowCopyToClipboard = false;
            }
            if (!(listItem instanceof RemoteListItem) || listItem.isContainer()) {
                // empty if block
            }
            if (!ListItemActionContextMenu.allowPaste(listItem)) {
                this.allowPaste = false;
            }
            if (!listItem.isWritable()) {
                this.allowPaste = false;
                this.allowRename = false;
            }
            if (!listItem.isReadable()) {
                this.allowCopy = false;
                this.allowCopyToClipboard = false;
                this.allowOpen = false;
                this.allowPaste = false;
                this.allowRename = false;
            }
            if (!listItem.isDeletable()) {
                this.allowDelete = false;
            }
            if (listItem instanceof LocalListItem) {
                this.allowCopyToClipboard = false;
            }
            if (listItem.isCourseAllowed() && !multipleSelected) {
                this.allowCreate = true;
                this.allowCourse = true;
            }
            if (listItem.isCategoryAllowed() && !multipleSelected) {
                this.allowCreate = true;
                this.allowCategory = true;
            }
            if (listItem.isGroupAllowed() && !multipleSelected) {
                this.allowCreate = true;
                this.allowGroup = true;
            }
            if (listItem.isFolderAllowed() && !multipleSelected) {
                this.allowCreate = true;
                this.allowFolder = true;
            }
            if (!listItem.isUpperLink()) continue;
            this.allowCreate = false;
            this.allowOpen = false;
            this.allowCopy = false;
            this.allowCopyToClipboard = false;
            this.allowRename = false;
            this.allowPaste = false;
            this.allowDelete = false;
        }
        if (this.getSource() instanceof ListView) {
            this.allowOpen = false;
            this.allowCopy = false;
            this.allowCopyToClipboard = false;
            this.allowRename = false;
            this.allowDelete = false;
            if (((ListItem)this.getSource().getUserData()).isCategoryAllowed()) {
                this.allowCreate = true;
                this.allowCategory = true;
            }
            if (((ListItem)this.getSource().getUserData()).isCourseAllowed()) {
                this.allowCreate = true;
                this.allowCourse = true;
            }
            if (((ListItem)this.getSource().getUserData()).isGroupAllowed()) {
                this.allowCreate = true;
                this.allowGroup = true;
            }
            if (((ListItem)this.getSource().getUserData()).isFolderAllowed()) {
                this.allowCreate = true;
                this.allowFolder = true;
            }
            logger.info("List view default id = " + String.valueOf(((ListItem)this.getSource().getUserData()).getRefId()));
        }
        if (!(clip = Clipboard.getSystemClipboard()).hasFiles()) {
            this.allowPaste = false;
        }
    }

    protected void populate() {
        this.getItems().addAll((Object[])new MenuItem[]{MenuItemBuilder.create().text("Open").accelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN})).graphic((Node)ImageViewBuilder.create().image(FileManagerUtils.getImageByName("edit.png")).build()).disable(!this.allowOpen).onAction((EventHandler)new ListItemContextMenuEventHandler((ListItem)this.getSource().getUserData(), 1)).build()});
        this.getItems().addAll((Object[])new MenuItem[]{SeparatorMenuItemBuilder.create().build()});
        this.getItems().addAll((Object[])new MenuItem[]{MenuItemBuilder.create().text("Copy to Clipboard").accelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN})).graphic((Node)ImageViewBuilder.create().image(FileManagerUtils.getImageByName("edit-copy.png")).build()).disable(!this.allowCopyToClipboard).onAction((EventHandler)new ListItemContextMenuEventHandler((ListItem)this.getSource().getUserData(), 6)).build()});
        this.getItems().addAll((Object[])new MenuItem[]{MenuItemBuilder.create().text("Paste").accelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN})).graphic((Node)ImageViewBuilder.create().image(FileManagerUtils.getImageByName("edit-paste.png")).build()).disable(!this.allowPaste).onAction((EventHandler)new ListItemContextMenuEventHandler((ListItem)this.getSource().getUserData(), 3)).build()});
        this.getItems().addAll((Object[])new MenuItem[]{SeparatorMenuItemBuilder.create().build()});
        this.getItems().addAll((Object[])new MenuItem[]{MenuItemBuilder.create().accelerator((KeyCombination)new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[0])).text("Delete").graphic((Node)ImageViewBuilder.create().image(FileManagerUtils.getImageByName("edit-delete.png")).build()).disable(!this.allowDelete).onAction((EventHandler)new ListItemContextMenuEventHandler((ListItem)this.getSource().getUserData(), 4)).build()});
        this.getItems().addAll((Object[])new MenuItem[]{MenuItemBuilder.create().text("Rename").accelerator((KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN})).graphic((Node)ImageViewBuilder.create().image(FileManagerUtils.getImageByName("edit-rename.png")).build()).disable(!this.allowRename).onAction((EventHandler)new ListItemContextMenuEventHandler((ListItem)this.getSource().getUserData(), 5)).build()});
        if (this.checkAllowLock()) {
            this.getItems().addAll((Object[])new MenuItem[]{MenuItemBuilder.create().text("Edit Revision State").accelerator((KeyCombination)new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN})).graphic((Node)ImageViewBuilder.create().image(FileManagerUtils.getImageByName("edit-revision.png")).build()).disable(false).onAction((EventHandler)new ListItemContextMenuEventHandler((ListItem)this.getSource().getUserData(), 20)).build()});
        }
        if (this.allowCreate) {
            this.getItems().addAll((Object[])new MenuItem[]{SeparatorMenuItemBuilder.create().build()});
            if (this.allowCategory) {
                this.getItems().addAll((Object[])new MenuItem[]{MenuItemBuilder.create().text("Create Category").graphic((Node)ImageViewBuilder.create().image(FileManagerUtils.getImageByName("icon_cat_s.gif")).build()).disable(false).onAction((EventHandler)new ListItemContextMenuEventHandler((ListItem)this.getSource().getUserData(), 7)).build()});
            }
            if (this.allowFolder) {
                this.getItems().addAll((Object[])new MenuItem[]{MenuItemBuilder.create().text("Create Folder").graphic((Node)ImageViewBuilder.create().image(FileManagerUtils.getImageByName("icon_fold_s.gif")).build()).disable(false).onAction((EventHandler)new ListItemContextMenuEventHandler((ListItem)this.getSource().getUserData(), 9)).build()});
            }
            if (this.allowCourse) {
                this.getItems().addAll((Object[])new MenuItem[]{MenuItemBuilder.create().text("Create Course").graphic((Node)ImageViewBuilder.create().image(FileManagerUtils.getImageByName("icon_crs_s.gif")).build()).disable(false).onAction((EventHandler)new ListItemContextMenuEventHandler((ListItem)this.getSource().getUserData(), 8)).build()});
            }
            if (this.allowGroup) {
                this.getItems().addAll((Object[])new MenuItem[]{MenuItemBuilder.create().text("Create Group").graphic((Node)ImageViewBuilder.create().image(FileManagerUtils.getImageByName("icon_grp_s.gif")).build()).disable(false).onAction((EventHandler)new ListItemContextMenuEventHandler((ListItem)this.getSource().getUserData(), 10)).build()});
            }
        }
    }

    protected boolean checkAllowLock() {
        if (this.getSelectedNodes().size() != 1) {
            return false;
        }
        for (Node node : this.getSelectedNodes()) {
            ListItem item = (ListItem)node.getUserData();
            if (!item.getType().equals("file") || !item.isWritable()) continue;
            logger.info("Item allows file lock");
            return true;
        }
        return false;
    }

    public static boolean allowPaste(ListItem item) {
        if (item.isContainer() && item.isWritable()) {
            return true;
        }
        return item.getType().equalsIgnoreCase("file") && item.isWritable();
    }
}

