/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.content;

import de.ilias.services.filemanager.content.ListItemProperty;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public abstract class ListItem
implements Comparable<ListItem> {
    private static final Logger logger = Logger.getLogger(ListItem.class.getName());
    private ListItem parent = null;
    private boolean isUpperLink = false;
    private int index = 0;
    private String filePath = "";
    private int refId = 0;
    private int objId = 0;
    private String title = "";
    private String type = "";
    private String fileType = "";
    private String description = "";
    private long sizeBit = 0L;
    private Date lastUpdate;
    private String permissions = "";
    private boolean isContainer = false;
    private boolean isReadable = false;
    private boolean isWritable = false;
    private boolean isDeletable = false;
    private boolean allowedCourse = false;
    private boolean allowedFolder = false;
    private boolean allowedGroup = false;
    private boolean allowedCategory = false;
    private List<ListItemProperty> properties = new ArrayList<ListItemProperty>();

    public void setParent(ListItem parent) {
        this.parent = parent;
    }

    public ListItem getParent() {
        return this.parent;
    }

    public boolean isUpperLink() {
        return this.isUpperLink;
    }

    public void setUpperLink(boolean stat) {
        this.isUpperLink = stat;
    }

    @Override
    public int compareTo(ListItem other) {
        if (this.getTitle().equals("..")) {
            return -1;
        }
        if (this.isContainer()) {
            if (other.isContainer) {
                return this.getTitle().compareToIgnoreCase(other.getTitle());
            }
            return -1;
        }
        if (other.isContainer) {
            return 1;
        }
        return this.getTitle().compareToIgnoreCase(other.getTitle());
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getAbsolutePath() {
        return this.filePath;
    }

    public void setAbsolutePath(String path) {
        this.filePath = path;
    }

    public int getRefId() {
        return this.refId;
    }

    public void setRefId(int refId) {
        this.refId = refId;
    }

    public int getObjId() {
        return this.objId;
    }

    public void setObjId(int id) {
        this.objId = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getFileType() {
        if (this.fileType.length() > 0) {
            return this.fileType;
        }
        return "    ";
    }

    public void setFileType(String type) {
        this.fileType = type;
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "";
            return "";
        }
        return this.description;
    }

    public void setFileSize(long size) {
        this.sizeBit = size;
    }

    public long getFileSize() {
        return this.sizeBit;
    }

    public String getReadableFileSize() {
        if (this.getFileSize() <= 0L) {
            return "";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(this.getFileSize()) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)this.getFileSize() / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public void setLastUpdate(Date last) {
        this.lastUpdate = last;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setPermissions(String perms) {
        this.permissions = perms;
    }

    public String getPermissions() {
        if (this.permissions.length() == 0) {
            return "  ";
        }
        return this.permissions;
    }

    public void setContainer(boolean container) {
        this.isContainer = container;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public boolean supportsCopyToClipboard() {
        if (this.getType().equals("crs")) {
            return false;
        }
        return !this.getType().equals("grp");
    }

    public void setReadable(boolean stat) {
        this.isReadable = stat;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public void setWritable(boolean write) {
        this.isWritable = write;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public void setDeletable(boolean stat) {
        this.isDeletable = stat;
    }

    public boolean isDeletable() {
        return this.isDeletable;
    }

    public void setCourseAllowed(boolean stat) {
        this.allowedCourse = stat;
    }

    public void setFolderAllowed(boolean stat) {
        this.allowedFolder = stat;
    }

    public void setGroupAllowed(boolean stat) {
        this.allowedGroup = stat;
    }

    public void setCategoryAllowed(boolean stat) {
        this.allowedCategory = stat;
    }

    public boolean isCourseAllowed() {
        return this.allowedCourse;
    }

    public boolean isFolderAllowed() {
        return this.allowedFolder;
    }

    public boolean isGroupAllowed() {
        return this.allowedGroup;
    }

    public boolean isCategoryAllowed() {
        return this.allowedCategory;
    }

    public boolean isPasteAllowed() {
        if (this.isContainer() && this.isWritable()) {
            return true;
        }
        return this.getType().equalsIgnoreCase("file") && this.isWritable();
    }

    public List<ListItemProperty> getProperties() {
        return this.properties;
    }
}

