/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.action;

import de.ilias.services.filemanager.FileManager;
import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.content.ListItemReader;
import de.ilias.services.filemanager.content.ListViewItemParser;
import de.ilias.services.filemanager.content.LocalListItem;
import de.ilias.services.filemanager.content.RemoteListItem;
import de.ilias.services.filemanager.controller.MainController;
import de.ilias.services.filemanager.dialog.PasteConflictDialog;
import de.ilias.services.filemanager.dialog.UploadLimitConflictDialog;
import de.ilias.services.filemanager.soap.SoapClientConnector;
import de.ilias.services.filemanager.soap.SoapClientConnectorException;
import de.ilias.services.filemanager.soap.api.SoapClientFile;
import de.ilias.services.filemanager.soap.api.SoapClientObject;
import de.ilias.services.filemanager.soap.api.SoapClientObjects;
import de.ilias.services.filemanager.utils.FileManagerUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;

public class ActionHandler {
    protected static final Logger logger = Logger.getLogger(ActionHandler.class.getName());
    protected static ArrayList<File> errorFiles = new ArrayList();

    public static boolean deleteItems(ArrayList<ListItem> selectItems) {
        for (ListItem item : selectItems) {
            if (item instanceof LocalListItem) {
                ActionHandler.deleteLocalFiles(new File(item.getAbsolutePath()));
            }
            if (!(item instanceof RemoteListItem)) continue;
            ActionHandler.deleteRemoteFiles(item.getRefId());
        }
        return true;
    }

    public static void deleteLocalFiles(File source) {
        logger.info(source.getAbsolutePath());
        if (source.getAbsolutePath().length() > 1000) {
            return;
        }
        File[] files = source.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    ActionHandler.deleteLocalFiles(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        source.delete();
    }

    public static void deleteRemoteFiles(int refId) {
        logger.info("Deleting ref id: " + refId);
        if (refId > 1) {
            SoapClientConnector con = SoapClientConnector.getInstance(1);
            con.deleteObject(refId);
        }
    }

    public static void copyRemoteToClipboard(ListItem source, ArrayList<ListItem> items) {
        ArrayList<ListItem> filteredItems = new ArrayList<ListItem>();
        for (ListItem item : items) {
            if (!item.supportsCopyToClipboard()) continue;
            filteredItems.add(item);
        }
        if (filteredItems.isEmpty()) {
            return;
        }
        File tmpDir = FileManagerUtils.createTempDirectory("ilfm_");
        tmpDir.deleteOnExit();
        Clipboard clip = Clipboard.getSystemClipboard();
        ClipboardContent clipContent = new ClipboardContent();
        ArrayList<File> files = new ArrayList<File>();
        for (ListItem item : filteredItems) {
            File newTempFile = ActionHandler.copyRemoteToTempDirectory(item, tmpDir);
            newTempFile.deleteOnExit();
            if (newTempFile == null) continue;
            files.add(newTempFile);
        }
        clipContent.putFiles(files);
        clip.setContent((Map)clipContent);
    }

    protected static File copyRemoteToTempDirectory(ListItem item, File target) {
        SoapClientConnector soap = SoapClientConnector.getInstance(1);
        if (item.getType().equalsIgnoreCase("file")) {
            try {
                SoapClientFile fileXML = soap.getFileXML(item.getRefId());
                File copied = fileXML.writeToFile(new File(target, item.getTitle()));
                logger.info("Renamed file to " + copied.getAbsolutePath());
                return copied;
            }
            catch (SoapClientConnectorException ex) {
                logger.warning("Cannot copy file to clipboard");
                return null;
            }
            catch (FileNotFoundException ex) {
                logger.warning("Cannot find file: " + target.getAbsolutePath() + "/" + item.getTitle());
            }
            catch (IOException ex) {
                logger.warning("Error copying file to: " + target.getAbsolutePath() + "/" + item.getTitle());
            }
        }
        if (item.getType().equals("fold") || item.getType().equals("cat")) {
            File newDirectory = new File(target, item.getTitle());
            newDirectory.mkdir();
            ListItemReader reader = new ListItemReader();
            try {
                reader.readRemoteContainer(item.getRefId(), false);
                for (ListItem child : reader.getListItems()) {
                    ActionHandler.copyRemoteToTempDirectory(child, newDirectory);
                }
            }
            catch (SoapClientConnectorException ex) {
                logger.warning("cannot read remote items");
            }
            return newDirectory;
        }
        return target;
    }

    public static boolean pasteFromClipboard(ListItem target, List<File> files) {
        Object conflictFiles = null;
        if (target instanceof LocalListItem) {
            logger.info("Copying to local");
            ActionHandler.copyFilesFromClipboardToLocal(target, files);
            return true;
        }
        if (target instanceof RemoteListItem) {
            if (ActionHandler.handleRemoteNamingConflict(target, files, true)) {
                return true;
            }
            logger.info("Copying to remote");
            ActionHandler.copyFilesFromClipboardToRemote(target, files, true);
        }
        return true;
    }

    public static boolean handleRemoteNamingConflict(ListItem target, List<File> files, boolean showDialog) {
        SoapClientObjects objects = null;
        HashMap<File, SoapClientObject> conflictFiles = null;
        PasteConflictDialog dia = null;
        ListItem pasteTarget = target;
        if (FileManager.getInstance().getFmMode() == 1 && !target.isContainer()) {
            pasteTarget = target.getParent();
        }
        try {
            objects = SoapClientConnector.getInstance(1).getTreeChilds(pasteTarget.getRefId());
            conflictFiles = objects.checkNamingConflict(files);
            if (conflictFiles.size() == 0) {
                return false;
            }
            if (!showDialog) {
                return true;
            }
            dia = new PasteConflictDialog(files, conflictFiles, pasteTarget, objects);
            dia.parse();
            MainController.getInstance().showModalDialog((Node)dia);
        }
        catch (SoapClientConnectorException ex) {
            logger.warning(ex.getMessage());
        }
        return true;
    }

    public static void copyFilesFromClipboardToLocal(ListItem target, List<File> files) {
        for (File source : files) {
            try {
                FileManagerUtils.copyDirectory(source, new File(target.getAbsolutePath(), source.getName()));
            }
            catch (FileNotFoundException e) {
                logger.warning(e.getMessage());
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
            }
        }
        MainController.getInstance().switchDirectory(target);
    }

    public static void copyFilesFromClipboardToRemote(ListItem target, List<File> files, boolean switchDirectory) {
        Iterator<File> filesIterator = files.iterator();
        int targetId = target.getRefId();
        logger.info("Target Id: " + targetId);
        logger.info("target type: " + target.getType());
        ListItem pasteTarget = target;
        errorFiles.clear();
        if (target.getType().equalsIgnoreCase("file")) {
            logger.info("Target is file");
            if (FileManager.getInstance().getFmMode() == 1) {
                logger.info("Explorer mode");
                pasteTarget = target.getParent();
                targetId = pasteTarget.getRefId();
            } else {
                logger.info("Default mode");
                ActionHandler.copyFilesFromClipboardToRemoteFile(target, files, switchDirectory);
                return;
            }
        }
        logger.info("Target is container");
        while (filesIterator.hasNext()) {
            File source = filesIterator.next();
            if (pasteTarget.getType().compareToIgnoreCase("root") == 0) {
                ActionHandler.createRemoteItem(source, targetId, "cat");
                continue;
            }
            if (pasteTarget.getType().compareToIgnoreCase("cat") == 0) {
                ActionHandler.createRemoteItem(source, targetId, "cat");
                continue;
            }
            ActionHandler.createRemoteItem(source, targetId, "fold");
        }
        if (errorFiles.size() > 0) {
            UploadLimitConflictDialog dia = new UploadLimitConflictDialog(errorFiles);
            dia.parse();
            MainController.getInstance().showModalDialog((Node)dia);
        }
        if (switchDirectory) {
            MainController.getInstance().switchDirectory(pasteTarget);
        }
    }

    public static void copyFilesFromClipboardToRemoteFile(ListItem target, List<File> files, boolean switchDirectory) {
        Iterator<File> filesIterator = files.iterator();
        int targetId = target.getRefId();
        logger.info("Creating new file version");
        while (filesIterator.hasNext()) {
            File source = filesIterator.next();
            if (source.isDirectory()) continue;
            logger.info("Adding new file version");
            logger.info("New file name " + source.getName());
            SoapClientFile file = new SoapClientFile();
            file.setFilename(source.getName());
            file.setTitle(source.getName());
            file.getContent().setContentFile(source);
            SoapClientConnector con = SoapClientConnector.getInstance(1);
            con.updateFile(file, targetId);
            if (switchDirectory) {
                MainController.getInstance().switchDirectory(target.getParent());
            }
            return;
        }
    }

    public static void createRemoteItem(File source, int targetId, String containerType) {
        if (source.isDirectory()) {
            SoapClientObjects objs = new SoapClientObjects();
            SoapClientObject obj = new SoapClientObject();
            obj.setTitle(source.getName());
            obj.setType(containerType);
            objs.getObjects().add(obj);
            SoapClientConnector con = SoapClientConnector.getInstance(1);
            int newRef = con.addObject(objs, targetId);
            logger.info("New ref id is: " + newRef);
            String[] childs = source.list();
            for (int i = 0; i < childs.length; ++i) {
                File child = new File(source.getAbsolutePath(), childs[i]);
                if (child.isHidden() || childs[i].substring(0, 1).compareTo(".") == 0 || childs[i].substring(0, 1).compareTo("..") == 0) continue;
                ActionHandler.createRemoteItem(child, newRef, containerType);
            }
        } else {
            if (!FileManagerUtils.checkAllowedFileSize(source, FileManager.getInstance().getUploadFilesize())) {
                errorFiles.add(source);
                return;
            }
            logger.info("Adding new file");
            logger.info("New file name " + source.getName());
            SoapClientFile file = new SoapClientFile();
            file.setFilename(source.getName());
            file.setTitle(source.getName());
            file.getContent().setContentFile(source);
            SoapClientConnector con = SoapClientConnector.getInstance(1);
            con.addFile(file, targetId);
        }
    }

    public static void searchRemote(String query) {
        SoapClientConnector con = SoapClientConnector.getInstance(1);
        SoapClientObjects objs = null;
        try {
            objs = con.search(query);
        }
        catch (SoapClientConnectorException ex) {
            logger.info("Searching failed");
        }
        ListItemReader reader = new ListItemReader();
        reader.setObjects(objs);
        try {
            reader.readRemoteContainer(1, false);
            ListViewItemParser parser = new ListViewItemParser(2);
            parser.setListItems(reader.getListItems());
            MainController.getInstance().populateSearchList(parser.parse());
        }
        catch (SoapClientConnectorException ex) {
            logger.warning(ex.getMessage());
            return;
        }
    }
}

