/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager;

import de.ilias.services.filemanager.controller.MainController;
import de.ilias.services.filemanager.layout.LayoutFactory;
import de.ilias.services.filemanager.layout.LayoutMaster;
import de.ilias.services.filemanager.rest.RestClientConnector;
import de.ilias.services.filemanager.soap.SoapClientConnector;
import de.ilias.services.filemanager.soap.SoapClientConnectorException;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.stage.Stage;
import netscape.javascript.JSObject;

public class FileManager
extends Application {
    private static final Logger logger = Logger.getLogger(FileManager.class.getName());
    public static final int FILE_MANAGER_MODE_DEFAULT = 0;
    public static final int FILE_MANAGER_MODE_EXPLORER = 1;
    private static FileManager instance = null;
    private JSObject browser = null;
    private boolean isApplet = false;
    private Stage stage = null;
    private int soapRid = 1;
    private String soapSid = "";
    private String soapClient = "filemanager";
    private String soapWsdl = "http://localhost/~stefan/ilias42_fm/webservice/soap/server.php?wsdl";
    private int soapUserId = 6;
    private String soapUser = "root";
    private String soapPass = "homerhomer";
    private String restServer = "http://localhost/~stefan/ilias42_fm/Services/WebServices/Rest/server.php";
    private String mainTitle = "ILIAS open source";
    private boolean fileLocks = false;
    private int uploadFileSize = 100;
    private int fmMode = 1;

    public static void main(String[] args) {
        Application.launch(FileManager.class, (String[])args);
    }

    public static FileManager getInstance() {
        return instance;
    }

    public Stage getStage() {
        return this.stage;
    }

    public boolean isApplet() {
        return this.isApplet;
    }

    public int getInitialRepositoryContainerId() {
        return this.soapRid;
    }

    public boolean enabledFileLocks() {
        return this.fileLocks;
    }

    public void setFmMode(int mode) {
        this.fmMode = mode;
    }

    public int getFmMode() {
        return this.fmMode;
    }

    public int getUploadFilesize() {
        return this.uploadFileSize;
    }

    public void setUploadFilesize(int size) {
        this.uploadFileSize = size;
    }

    public void start(Stage stage) throws Exception {
        long mem = Runtime.getRuntime().maxMemory();
        logger.info("Max memory: " + String.valueOf(mem));
        this.initEnvironment(stage);
        this.initSoapConnector();
        this.initRestConnector();
        LayoutMaster master = null;
        try {
            master = LayoutFactory.getInstance(stage);
            master.init();
            master.show();
            MainController.getInstance().getMainTitle().setText(this.mainTitle);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
            e.printStackTrace();
        }
    }

    private void initEnvironment(Stage st) {
        instance = this;
        this.stage = st;
        Logger.getLogger("de.ilias.services.filemanager").setLevel(Level.ALL);
        this.stage.setTitle("File Manager - ILIAS");
        try {
            this.browser = this.getHostServices().getWebContext();
            if (this.browser != null) {
                this.isApplet = true;
            }
        }
        catch (Exception e) {
            this.isApplet = false;
            System.out.println(e.getMessage());
        }
        Application.Parameters params = this.getParameters();
        Map map = params.getNamed();
        if (map.containsKey("sid")) {
            this.soapSid = (String)map.get("sid");
        }
        if (map.containsKey("uid")) {
            this.soapUserId = Integer.parseInt((String)map.get("uid"));
        }
        if (map.containsKey("rid")) {
            this.soapRid = Integer.parseInt((String)map.get("rid"));
        }
        if (map.containsKey("wsd")) {
            this.soapWsdl = (String)map.get("wsd");
        }
        if (map.containsKey("restServer")) {
            this.restServer = (String)map.get("restServer");
        }
        if (map.containsKey("localFrame")) {
            LayoutFactory.getInstance(st).enableLocalFrame(((String)map.get("localFrame")).equalsIgnoreCase("1"));
        }
        if (map.containsKey("headerTitle")) {
            this.mainTitle = (String)map.get("headerTitle");
        }
        if (map.containsKey("fileLocks")) {
            boolean bl = this.fileLocks = ((String)map.get("fileLocks")).equalsIgnoreCase("1");
        }
        if (map.containsKey("explorerMode")) {
            int n = this.fmMode = ((String)map.get("explorerMode")).equalsIgnoreCase("1") ? 1 : 0;
        }
        if (map.containsKey("uploadFileSize")) {
            this.setUploadFilesize(Integer.parseInt((String)map.get("uploadFileSize")));
        }
    }

    private void initSoapConnector() {
        try {
            SoapClientConnector client = SoapClientConnector.getInstance();
            client.setWsdlUri(this.soapWsdl);
            client.setClient(this.soapClient);
            client.setUser(this.soapUser);
            client.setUserId(this.soapUserId);
            client.setPassword(this.soapPass);
            client.setSessionId(this.soapSid);
            client.init();
            client.initUser();
        }
        catch (SoapClientConnectorException ex) {
            logger.severe(ex.getMessage());
            logger.log(Level.SEVERE, ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void initRestConnector() {
        RestClientConnector client = RestClientConnector.getInstance();
        client.setServer(this.restServer);
    }
}

